/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.FontManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;

public class StyleManager {
    private Workbook workbook;
    private FontManager fm;
    private List<StylePair> styles = new ArrayList<StylePair>();
    private StyleManagerUtils smu;
    private CSSEngine cssEngine;
    private Logger log;
    private Locale locale;
    static int[] COMPARE_CSS_PROPERTIES = new int[]{23, 8, 49, 41, 13, 52, 42, 46, 21, 10, 14, 22, 11, 15, 60, 48};

    public StyleManager(Workbook workbook, Logger log, StyleManagerUtils smu, CSSEngine cssEngine, Locale locale) {
        this.workbook = workbook;
        this.fm = new FontManager(cssEngine, workbook, smu);
        this.log = log;
        this.smu = smu;
        this.cssEngine = cssEngine;
        this.locale = locale;
    }

    public FontManager getFontManager() {
        return this.fm;
    }

    public CSSEngine getCssEngine() {
        return this.cssEngine;
    }

    private boolean stylesEquivalent(BirtStyle style1, BirtStyle style2) {
        int i = 0;
        while (i < COMPARE_CSS_PROPERTIES.length) {
            CSSValue value2;
            int prop = COMPARE_CSS_PROPERTIES[i];
            CSSValue value1 = style1.getProperty(prop);
            if (!StyleManagerUtils.objectsEqual(value1, value2 = style2.getProperty(prop))) {
                return false;
            }
            ++i;
        }
        if (!StyleManagerUtils.objectsEqual(style1.getProperty(61), style2.getProperty(61))) {
            return false;
        }
        if (!StyleManagerUtils.dataFormatsEquivalent((DataFormatValue)style1.getProperty(1), (DataFormatValue)style2.getProperty(1))) {
            return false;
        }
        return FontManager.fontsEquivalent(style1, style2);
    }

    private CellStyle createStyle(BirtStyle birtStyle) {
        CellStyle poiStyle = this.workbook.createCellStyle();
        Font font = this.fm.getFont(birtStyle);
        if (font != null) {
            poiStyle.setFont(font);
        }
        poiStyle.setAlignment(this.smu.poiAlignmentFromBirtAlignment(birtStyle.getString(23)));
        this.smu.addBackgroundColourToStyle(this.workbook, poiStyle, birtStyle.getString(8));
        this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.TOP, birtStyle.getProperty(13), birtStyle.getProperty(49), birtStyle.getProperty(41));
        this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.LEFT, birtStyle.getProperty(46), birtStyle.getProperty(52), birtStyle.getProperty(42));
        this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.RIGHT, birtStyle.getProperty(14), birtStyle.getProperty(21), birtStyle.getProperty(10));
        this.smu.applyBorderStyle(this.workbook, poiStyle, XSSFCellBorder.BorderSide.BOTTOM, birtStyle.getProperty(15), birtStyle.getProperty(22), birtStyle.getProperty(11));
        this.smu.applyNumberFormat(this.workbook, birtStyle, poiStyle, this.locale);
        if ("pre".equals(birtStyle.getString(60))) {
            poiStyle.setWrapText(true);
        }
        if ("top".equals(birtStyle.getString(48))) {
            poiStyle.setVerticalAlignment((short)0);
        } else if ("middle".equals(birtStyle.getString(48))) {
            poiStyle.setVerticalAlignment((short)1);
        } else if ("bottom".equals(birtStyle.getString(48))) {
            poiStyle.setVerticalAlignment((short)2);
        }
        CSSValue rotation = birtStyle.getProperty(61);
        if (rotation instanceof FloatValue) {
            poiStyle.setRotation((short)((FloatValue)rotation).getFloatValue());
        }
        this.styles.add(new StylePair(birtStyle.clone(), poiStyle));
        return poiStyle;
    }

    public CellStyle getStyle(BirtStyle birtStyle) {
        for (StylePair stylePair : this.styles) {
            if (!this.stylesEquivalent(birtStyle, stylePair.birtStyle)) continue;
            return stylePair.poiStyle;
        }
        return this.createStyle(birtStyle);
    }

    private BirtStyle birtStyleFromCellStyle(CellStyle source) {
        for (StylePair stylePair : this.styles) {
            if (!source.equals(stylePair.poiStyle)) continue;
            return stylePair.birtStyle.clone();
        }
        return new BirtStyle(this.cssEngine);
    }

    public CellStyle getStyleWithBorders(CellStyle source, CSSValue borderStyleBottom, CSSValue borderWidthBottom, CSSValue borderColourBottom, CSSValue borderStyleLeft, CSSValue borderWidthLeft, CSSValue borderColourLeft, CSSValue borderStyleRight, CSSValue borderWidthRight, CSSValue borderColourRight, CSSValue borderStyleTop, CSSValue borderWidthTop, CSSValue borderColourTop) {
        BirtStyle birtStyle = this.birtStyleFromCellStyle(source);
        if (borderStyleBottom != null && borderWidthBottom != null && borderColourBottom != null) {
            birtStyle.setProperty(22, borderStyleBottom);
            birtStyle.setProperty(11, borderWidthBottom);
            birtStyle.setProperty(15, borderColourBottom);
        }
        if (borderStyleLeft != null && borderWidthLeft != null && borderColourLeft != null) {
            birtStyle.setProperty(52, borderStyleLeft);
            birtStyle.setProperty(42, borderWidthLeft);
            birtStyle.setProperty(46, borderColourLeft);
        }
        if (borderStyleRight != null && borderWidthRight != null && borderColourRight != null) {
            birtStyle.setProperty(21, borderStyleRight);
            birtStyle.setProperty(10, borderWidthRight);
            birtStyle.setProperty(14, borderColourRight);
        }
        if (borderStyleTop != null && borderWidthTop != null && borderColourTop != null) {
            birtStyle.setProperty(49, borderStyleTop);
            birtStyle.setProperty(41, borderWidthTop);
            birtStyle.setProperty(13, borderColourTop);
        }
        CellStyle newStyle = this.getStyle(birtStyle);
        return newStyle;
    }

    public CellStyle getStyleWithExtraStyle(CellStyle source, IStyle birtExtraStyle) {
        BirtStyle birtStyle = this.birtStyleFromCellStyle(source);
        int i = 0;
        while (i < 62) {
            CSSValue value = birtExtraStyle.getProperty(i);
            if (value != null) {
                birtStyle.setProperty(i, value);
            }
            ++i;
        }
        CellStyle newStyle = this.getStyle(birtStyle);
        return newStyle;
    }

    private class StylePair {
        public BirtStyle birtStyle;
        public CellStyle poiStyle;

        public StylePair(BirtStyle birtStyle, CellStyle poiStyle) {
            this.birtStyle = birtStyle;
            this.poiStyle = poiStyle;
        }
    }
}

