/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IHasChildren;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageRoot;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.FilterConfigurer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.ImageContainer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginBundleContainer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.ProjectImageContainer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.WorkspacePluginInfo;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImagesRoot
implements IImageRoot {
    private final IProject m_project;
    private final FilterConfigurer m_filterConfigurer;
    private final IPluginModelBase m_pluginModel;
    private String m_currentValueBundle;
    private ImageContainer[] m_containers;

    public PluginImagesRoot(IProject project, FilterConfigurer filterConfigurer) {
        this.m_project = project;
        this.m_filterConfigurer = filterConfigurer;
        this.m_pluginModel = PluginRegistry.findModel((IProject)project);
    }

    public IImageElement[] elements() {
        if (this.m_filterConfigurer.isDirty()) {
            try {
                Bundle bundle;
                IPluginModelBase[] iPluginModelBaseArray;
                String pluginId;
                IPluginModelBase pluginModel;
                IProject project;
                int n;
                int n2;
                IProject[] iProjectArray;
                this.dispose();
                HashSet<IPluginModelBase> includeModels = new HashSet<IPluginModelBase>();
                HashMap<IPluginModelBase, IProject> workspaceModelToProject = new HashMap<IPluginModelBase, IProject>();
                ArrayList<ImageContainer> containers = new ArrayList<ImageContainer>();
                String thisPluginId = PluginImagesRoot.getPluginId(this.m_pluginModel);
                if (thisPluginId != null) {
                    PluginImagesRoot.addToContainer(containers, new ProjectImageContainer(this.m_project, thisPluginId));
                }
                boolean findCurrentValueBundle = this.m_currentValueBundle != null;
                IPluginModelBase currentValuePluginModel = null;
                if (findCurrentValueBundle && ((currentValuePluginModel = PluginRegistry.findModel((String)this.m_currentValueBundle)) == null || currentValuePluginModel == this.m_pluginModel)) {
                    findCurrentValueBundle = false;
                    currentValuePluginModel = null;
                }
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                if (this.m_filterConfigurer.showWorkspacePlugins()) {
                    iProjectArray = projects;
                    n2 = projects.length;
                    n = 0;
                    while (n < n2) {
                        project = iProjectArray[n];
                        if (this.m_project != project && PluginImagesRoot.isPluginProject(project) && (pluginModel = PluginRegistry.findModel((IProject)project)) != null && (pluginId = PluginImagesRoot.getPluginId(pluginModel)) != null) {
                            includeModels.add(pluginModel);
                            PluginImagesRoot.addToContainer(containers, new ProjectImageContainer(project, pluginId));
                        }
                        ++n;
                    }
                } else {
                    iProjectArray = projects;
                    n2 = projects.length;
                    n = 0;
                    while (n < n2) {
                        project = iProjectArray[n];
                        if (this.m_project != project && PluginImagesRoot.isPluginProject(project) && (pluginModel = PluginRegistry.findModel((IProject)project)) != null) {
                            workspaceModelToProject.put(pluginModel, project);
                        }
                        ++n;
                    }
                }
                if (this.m_filterConfigurer.showRequiredPlugins()) {
                    List<String> requiredPlugins = WorkspacePluginInfo.getRequiredPlugins(this.m_project);
                    for (String symbolicName : requiredPlugins) {
                        ModelEntry pluginEntry = PluginRegistry.findEntry((String)symbolicName);
                        if (pluginEntry == null) continue;
                        pluginModel = pluginEntry.getModel();
                        if (pluginEntry.hasWorkspaceModels()) {
                            String pluginId2;
                            IProject project2;
                            if (this.m_filterConfigurer.showWorkspacePlugins() || (project2 = (IProject)workspaceModelToProject.get(pluginModel)) == null || (pluginId2 = PluginImagesRoot.getPluginId(pluginModel)) == null) continue;
                            includeModels.add(pluginModel);
                            PluginImagesRoot.addToContainer(containers, new ProjectImageContainer(project2, pluginId2));
                            continue;
                        }
                        includeModels.add(pluginModel);
                        Bundle bundle2 = Platform.getBundle((String)symbolicName);
                        PluginImagesRoot.addToContainer(containers, new PluginBundleContainer(symbolicName, bundle2, symbolicName));
                    }
                }
                if (findCurrentValueBundle) {
                    ModelEntry pluginEntry;
                    if (!includeModels.contains(currentValuePluginModel) && (pluginEntry = PluginRegistry.findEntry((String)this.m_currentValueBundle)) != null) {
                        if (pluginEntry.hasWorkspaceModels()) {
                            IProject project3;
                            if (!this.m_filterConfigurer.showWorkspacePlugins() && (project3 = (IProject)workspaceModelToProject.get(currentValuePluginModel)) != null) {
                                includeModels.add(currentValuePluginModel);
                                PluginImagesRoot.addToContainer(containers, new ProjectImageContainer(project3, this.m_currentValueBundle));
                            }
                        } else {
                            includeModels.add(currentValuePluginModel);
                            Bundle bundle3 = Platform.getBundle((String)this.m_currentValueBundle);
                            containers.add(0, new PluginBundleContainer(this.m_currentValueBundle, bundle3, this.m_currentValueBundle));
                        }
                    }
                    findCurrentValueBundle = false;
                    currentValuePluginModel = null;
                }
                IPluginModelBase[] allModels = PluginRegistry.getAllModels();
                if (this.m_filterConfigurer.showUIPlugins()) {
                    iPluginModelBaseArray = allModels;
                    int n3 = allModels.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginModelBase pluginModel2 = iPluginModelBaseArray[n4];
                        pluginId = PluginImagesRoot.getPluginId(pluginModel2);
                        if (pluginId != null && pluginId.endsWith(".ui") && !includeModels.contains(pluginModel2)) {
                            bundle = Platform.getBundle((String)pluginId);
                            PluginImagesRoot.addToContainer(containers, new PluginBundleContainer(pluginId, bundle, pluginId));
                        }
                        ++n4;
                    }
                } else if (this.m_filterConfigurer.showAllPlugins()) {
                    iPluginModelBaseArray = allModels;
                    int n5 = allModels.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IPluginModelBase pluginModel3 = iPluginModelBaseArray[n6];
                        if (!includeModels.contains(pluginModel3) && (pluginId = PluginImagesRoot.getPluginId(pluginModel3)) != null) {
                            bundle = Platform.getBundle((String)pluginId);
                            PluginImagesRoot.addToContainer(containers, new PluginBundleContainer(pluginId, bundle, pluginId));
                        }
                        ++n6;
                    }
                }
                Collections.sort(containers, new Comparator<ImageContainer>(){

                    @Override
                    public int compare(ImageContainer container1, ImageContainer container2) {
                        return container1.getName().compareTo(container2.getName());
                    }
                });
                this.m_containers = containers.toArray(new ImageContainer[containers.size()]);
                this.m_filterConfigurer.resetState();
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
        }
        return this.m_containers;
    }

    private static void addToContainer(List<ImageContainer> containers, ImageContainer container) {
        IHasChildren tester = (IHasChildren)container;
        if (tester.hasChildren()) {
            containers.add(container);
        }
    }

    public void init(Object data) {
        if (data != null) {
            String[] parts = (String[])data;
            this.m_currentValueBundle = parts[0];
        }
    }

    public void dispose() {
        if (this.m_containers != null) {
            ImageContainer[] imageContainerArray = this.m_containers;
            int n = this.m_containers.length;
            int n2 = 0;
            while (n2 < n) {
                ImageContainer container = imageContainerArray[n2];
                container.dispose();
                ++n2;
            }
            this.m_containers = null;
        }
    }

    public Object[] getSelectionPath(Object data) {
        String[] parts = (String[])data;
        String symbolicName = parts[0];
        String imagePath = parts[1];
        this.elements();
        ImageContainer[] imageContainerArray = this.m_containers;
        int n = this.m_containers.length;
        int n2 = 0;
        while (n2 < n) {
            ImageContainer container = imageContainerArray[n2];
            Object[] resource = container.findResource(symbolicName, imagePath);
            if (resource != null) {
                return resource;
            }
            ++n2;
        }
        return null;
    }

    private static String getPluginId(IPluginModelBase pluginModel) {
        BundleDescription bundleDescription = pluginModel.getBundleDescription();
        return bundleDescription == null ? null : bundleDescription.getSymbolicName();
    }

    private static boolean isPluginProject(IProject project) throws Exception {
        return project.exists() && project.isOpen() && project.hasNature("org.eclipse.pde.PluginNature") && (project.getFile(WorkspacePluginInfo.MANIFEST_PATH).exists() || project.getFile(WorkspacePluginInfo.PLUGIN_PATH).exists());
    }

    public static boolean testPluginProject(IProject project) {
        try {
            return PluginImagesRoot.isPluginProject(project);
        }
        catch (Throwable e) {
            return false;
        }
    }
}

