/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.views.timegraph;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.ui.PlatformUI;

public class TimeEventFilterDialog
extends Dialog {
    public static final String EMPTY_STRING = "";
    private static final int FIND_X_WIDTH_HINT = 200;
    private static final int MAX_FILTER_REGEX_SIZE = 4;
    private static final int Y_OFFSET = -15;
    private String fRegex;
    private Set<@NonNull String> fFilterRegexes = new LinkedHashSet<String>(4);
    private final TimeGraphControl fControl;
    private final AbstractTimeGraphView fView;
    private final ControlListener fControlListener = new ControlMovedListener();

    public TimeEventFilterDialog(Shell parentShell, AbstractTimeGraphView view, TimeGraphControl control) {
        super(parentShell);
        this.fView = view;
        this.fControl = control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.AbstractTimeGraphView_TimeEventFilterDialogTitle);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Composite labels = TimeEventFilterDialog.createCLabelsArea(container);
        this.createFilterTextArea(parent, container, labels);
        this.createCloseButton(container);
        this.getShell().addListener(31, e -> {
            if (e.detail == 2) {
                this.clearFilter();
            }
        });
        for (String label : this.fFilterRegexes) {
            this.createCLabels(parent, labels, label);
        }
        this.fControl.addControlListener(this.fControlListener);
        this.fControl.getShell().addControlListener(this.fControlListener);
        return parent;
    }

    private static Composite createCLabelsArea(Composite container) {
        Composite labels = new Composite(container, 0);
        GridData gd = new GridData(0x1000000, 0x1000000, false, false);
        labels.setLayoutData((Object)gd);
        RowLayout rl = new RowLayout(256);
        rl.marginTop = 0;
        rl.marginBottom = 0;
        rl.marginLeft = 3;
        rl.marginRight = 0;
        labels.setLayout((Layout)rl);
        return labels;
    }

    private Text createFilterTextArea(final Composite parent, Composite container, final Composite labels) {
        final Text filterText = new Text(container, 2944);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 200;
        filterText.setLayoutData((Object)gridData);
        if (this.fRegex != null) {
            filterText.setText(this.fRegex);
        }
        filterText.addModifyListener(e -> {
            this.fRegex = filterText.getText();
            this.fView.restartZoomThread();
        });
        filterText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    TimeEventFilterDialog.this.handleEnterPressed(parent, labels, filterText);
                }
            }
        });
        return filterText;
    }

    private void clearFilter() {
        this.fRegex = EMPTY_STRING;
        this.fFilterRegexes.clear();
        this.fView.restartZoomThread();
    }

    private void handleEnterPressed(Composite parent, Composite labels, Text filterText) {
        String currentRegex = filterText.getText();
        if (currentRegex.isEmpty() || this.fFilterRegexes.size() == 4 || this.fFilterRegexes.contains(currentRegex)) {
            filterText.setBackground(this.fControl.getColorScheme().getColor(38));
            return;
        }
        boolean added = this.fFilterRegexes.add(currentRegex);
        if (added) {
            filterText.setText(EMPTY_STRING);
            this.fRegex = EMPTY_STRING;
            this.createCLabels(parent, labels, currentRegex);
        }
    }

    private Button createCloseButton(Composite composite) {
        Button closeButton = new Button(composite, 0);
        closeButton.setToolTipText(Messages.TimeEventFilterDialog_CloseButton);
        closeButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        closeButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeEventFilterDialog.this.clearFilter();
                TimeEventFilterDialog.this.close();
            }
        });
        return closeButton;
    }

    private void createCLabels(final Composite parent, Composite labels, String currentRegex) {
        final CLabel filter = new CLabel(labels, 2048);
        filter.setText(currentRegex);
        filter.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        filter.setBackground(this.fControl.getColorScheme().getColor(38));
        filter.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e2) {
                TimeEventFilterDialog.this.deleteCLabel(parent, filter, e2);
            }
        });
        parent.layout();
        Rectangle bounds = parent.getShell().getBounds();
        Point size = parent.computeSize(-1, -1);
        Rectangle trim = parent.getShell().computeTrim(0, 0, size.x, size.y);
        parent.getShell().setBounds(bounds.x + bounds.width - trim.width, bounds.y + bounds.height - trim.height, trim.width, trim.height);
    }

    private void deleteCLabel(Composite parent, CLabel cLabel, MouseEvent e) {
        Rectangle imageBounds = cLabel.getImage().getBounds();
        imageBounds.x += cLabel.getLeftMargin();
        imageBounds.y = (cLabel.getSize().y - imageBounds.height) / 2;
        if (imageBounds.contains(e.x, e.y)) {
            this.fFilterRegexes.removeIf(regex -> regex.equals(cLabel.getText()));
            e.widget.dispose();
            parent.layout();
            Rectangle bounds = parent.getShell().getBounds();
            Point size = parent.computeSize(-1, -1);
            Rectangle trim = parent.getShell().computeTrim(0, 0, size.x, size.y);
            int x = bounds.x + (bounds.width - trim.width);
            parent.getShell().setSize(trim.width, trim.height);
            Display.getDefault().asyncExec(() -> parent.getShell().setLocation(x, rectangle.y));
            this.fView.restartZoomThread();
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(8);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 0;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point p = this.getFilterLocation();
        if (p != null) {
            return p;
        }
        return super.getInitialLocation(initialSize);
    }

    public boolean close() {
        if (!this.fControl.isDisposed()) {
            this.fControl.removeControlListener(this.fControlListener);
            this.fControl.getShell().removeControlListener(this.fControlListener);
        }
        return super.close();
    }

    public @Nullable Point getFilterLocation() {
        if (!this.fControl.isDisposed()) {
            Rectangle bounds = this.fControl.getBounds();
            int width = this.getShell().computeSize((int)-1, (int)-1).x;
            return this.fControl.toDisplay(new Point(bounds.x + bounds.width - width, bounds.y + bounds.height + -15));
        }
        return null;
    }

    public boolean isFilterActive() {
        return !NonNullUtils.nullToEmptyString((Object)this.fRegex).isEmpty() || this.hasActiveSavedFilters();
    }

    public boolean hasActiveSavedFilters() {
        return !this.fFilterRegexes.isEmpty();
    }

    public @NonNull String getTextBoxRegex() {
        return NonNullUtils.nullToEmptyString((Object)this.fRegex);
    }

    public Set<@NonNull String> getSavedFilters() {
        return this.fFilterRegexes;
    }

    private class ControlMovedListener
    implements ControlListener {
        private ControlMovedListener() {
        }

        public void controlMoved(@Nullable ControlEvent e) {
            this.resize();
        }

        public void controlResized(@Nullable ControlEvent e) {
            this.resize();
        }

        private void resize() {
            if (TimeEventFilterDialog.this.getShell() == null) {
                return;
            }
            Point size = TimeEventFilterDialog.this.getInitialSize();
            Point location = TimeEventFilterDialog.this.getFilterLocation();
            if (location != null) {
                TimeEventFilterDialog.this.getShell().setBounds(TimeEventFilterDialog.this.getConstrainedShellBounds(new Rectangle(location.x, location.y, size.x, size.y)));
            }
        }
    }
}

