/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.PDELocationUtils;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformInitializer;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;

public class Q7TargetPlatformManager {
    private static Map<String, ITargetPlatformHelper> cachedHelpers = new HashMap<String, ITargetPlatformHelper>();

    public static synchronized ITargetPlatformHelper findTarget(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        String location = config.getAttribute("aut-location", "");
        File loc = new File(location);
        if (!loc.exists()) {
            return null;
        }
        String targetPlatform = Q7TargetPlatformManager.getTargetPlatformName(config);
        ITargetPlatformHelper cached = cachedHelpers.get(targetPlatform);
        if (cached != null) {
            return cached;
        }
        monitor.beginTask("Initialize target platform...", 2);
        ITargetPlatformHelper info = TargetPlatformManager.findTarget(targetPlatform, (IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
        assert (info.getStatus().isOK());
        monitor.worked(1);
        monitor.done();
        cachedHelpers.put(targetPlatform, info);
        return info;
    }

    public static synchronized ITargetPlatformHelper getTarget(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        String location = config.getAttribute("aut-location", "");
        if (!PDELocationUtils.validateProductLocation(location).isOK()) {
            return Q7TargetPlatformManager.newTargetPlatform(config, monitor, location);
        }
        String targetPlatformName = Q7TargetPlatformManager.getTargetPlatformName(config);
        monitor.beginTask("Initialize target platform...", 2);
        ITargetPlatformHelper info = TargetPlatformManager.findTarget(targetPlatformName, (IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
        if (info == null) {
            info = Q7TargetPlatformManager.newTargetPlatform(config, (IProgressMonitor)new SubProgressMonitor(monitor, 1), location);
            assert (info != null);
        } else {
            monitor.worked(1);
        }
        assert (info != null);
        monitor.done();
        cachedHelpers.put(targetPlatformName, info);
        return info;
    }

    private static synchronized ITargetPlatformHelper newTargetPlatform(ILaunchConfiguration config, IProgressMonitor monitor, String location) throws CoreException {
        String name = Q7TargetPlatformManager.getTargetPlatformName(config);
        ITargetPlatformHelper info = Q7TargetPlatformManager.createTargetPlatform(location, monitor);
        assert (info != null);
        info.setTargetName(name);
        info.save();
        cachedHelpers.put(info.getName(), info);
        return info;
    }

    private static void throwOnError(IStatus status) throws CoreException {
        if (status.matches(4)) {
            throw new CoreException(status);
        }
        if (!status.isOK()) {
            Q7ExtLaunchingPlugin.log(status);
        }
    }

    public static synchronized ITargetPlatformHelper createTargetPlatform(String location, IProgressMonitor monitor) throws CoreException {
        boolean isOk = false;
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        ITargetPlatformHelper platform = null;
        try {
            monitor.beginTask("Create AUT configuration", 100);
            platform = TargetPlatformManager.createTargetPlatform(location, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            Q7TargetPlatformManager.throwOnError(platform.getStatus());
            IStatus rv = Q7TargetPlatformInitializer.initialize(platform, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            Q7TargetPlatformManager.throwOnError(rv);
            isOk = true;
            ITargetPlatformHelper iTargetPlatformHelper = platform;
            return iTargetPlatformHelper;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", "Target platform initialization failed", e));
        }
        finally {
            if (!isOk && platform != null) {
                platform.delete();
            }
            monitor.done();
        }
    }

    public static String getTargetPlatformName(ILaunchConfiguration config) {
        String defValue = Q7TargetPlatformManager.getTargetPlatformName(config.getName());
        try {
            return config.getAttribute("aut-target-platform", defValue);
        }
        catch (CoreException e) {
            RcpttPlugin.log((Throwable)e);
            return defValue;
        }
    }

    public static String getTargetPlatformName(String name) {
        return "AUT " + name + " (Target Platform)";
    }

    public static synchronized void initialize() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(new ILaunchConfigurationListener(){

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                String target = Q7TargetPlatformManager.getTargetPlatformName(configuration);
                if (target != null) {
                    TargetPlatformManager.deleteTargetPlatform(target);
                    cachedHelpers.remove(target);
                }
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }
        });
    }

    public static synchronized void setHelper(String name, ITargetPlatformHelper info) {
        cachedHelpers.put(name, info);
    }

    public static synchronized ITargetPlatformHelper getHelper(String name) {
        return cachedHelpers.get(name);
    }

    public static synchronized void delete(String name) {
        cachedHelpers.remove(name);
    }

    public static synchronized void clear() {
        cachedHelpers.clear();
    }
}

