/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class HeadAnalysis {
    protected final @NonNull MappingRegion mappingRegion;

    protected HeadAnalysis(@NonNull MappingRegion mappingRegion) {
        this.mappingRegion = mappingRegion;
    }

    protected @NonNull List<@NonNull HeadNodeGroup> computeHeadNodeGroups(@NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourcesClosure, @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> sourceToTargetsClosure, @Nullable List<@NonNull Node> preferredHeadNodes) {
        Object headNodeGroup;
        ArrayList<@NonNull E> headLessNodes = new ArrayList();
        Iterables.addAll(headLessNodes, targetFromSourcesClosure.keySet());
        Collections.sort(headLessNodes, new HeadComparator(targetFromSourcesClosure, preferredHeadNodes));
        ArrayList<@NonNull HeadNodeGroup> headNodeGroups = new ArrayList<HeadNodeGroup>();
        HashSet<@NonNull Node> reachableNodes = new HashSet<Node>();
        while (!headLessNodes.isEmpty()) {
            Node headNode = (Node)headLessNodes.remove(0);
            assert (headNode != null);
            headNodeGroup = new ArrayList<Node>();
            headNodeGroup.add(headNode);
            Set<@NonNull Node> debugSourceClosure = targetFromSourcesClosure.get(headNode);
            Set<@NonNull Node> targetsClosure = sourceToTargetsClosure.get(headNode);
            assert (targetsClosure != null);
            for (Node targetNode : targetsClosure) {
                if (!reachableNodes.add(targetNode)) continue;
                headLessNodes.remove(targetNode);
                if (targetNode == headNode) continue;
                Set<@NonNull Node> otherTargetsClosure = sourceToTargetsClosure.get(targetNode);
                assert (otherTargetsClosure != null);
                if (!otherTargetsClosure.contains(headNode)) continue;
                headNodeGroup.add(targetNode);
            }
            headNodeGroups.add(new HeadNodeGroup((List<Node>)headNodeGroup));
        }
        if (headNodeGroups.size() > 1) {
            int iGroup = headNodeGroups.size() - 1;
            while (iGroup >= 0) {
                headNodeGroup = (HeadNodeGroup)headNodeGroups.get(iGroup);
                for (HeadNodeGroup otherHeadNodeGroup : headNodeGroups) {
                    if (otherHeadNodeGroup == headNodeGroup || !((HeadNodeGroup)headNodeGroup).isDeriveableFrom(otherHeadNodeGroup)) continue;
                    headNodeGroups.remove(iGroup);
                    break;
                }
                --iGroup;
            }
        }
        return headNodeGroups;
    }

    protected @NonNull List<@NonNull Node> selectHeadNodes(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups, @Nullable Iterable<@NonNull Node> preferredHeadNodes) {
        ArrayList<@NonNull Node> headNodes = new ArrayList<Node>();
        for (HeadNodeGroup headNodeGroup : headNodeGroups) {
            Node headNode = headNodeGroup.getPreferredHeadNode(preferredHeadNodes);
            assert (!headNodes.contains(headNode));
            headNodes.add(headNode);
        }
        return headNodes;
    }

    public String toString() {
        return this.mappingRegion.toString();
    }

    protected static class HeadComparator
    implements Comparator<Node> {
        private final @NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure;
        private final @Nullable List<@NonNull Node> preferredHeadNodes;
        private @Nullable Map<@NonNull Node, @NonNull Integer> node2implicity = null;

        public HeadComparator(@NonNull Map<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure, @Nullable List<@NonNull Node> preferredHeadNodes) {
            this.targetFromSourceClosure = targetFromSourceClosure;
            this.preferredHeadNodes = preferredHeadNodes;
        }

        @Override
        public int compare(@NonNull Node o1, @NonNull Node o2) {
            int i2;
            boolean c2;
            int l2;
            int i22;
            int i1;
            boolean d2;
            boolean d1 = o1.isDataType();
            if (d1 != (d2 = o2.isDataType())) {
                return d1 ? 1 : -1;
            }
            List<@NonNull Node> preferredHeadNodes2 = this.preferredHeadNodes;
            if (preferredHeadNodes2 != null && (i1 = preferredHeadNodes2.indexOf(o1)) != (i22 = preferredHeadNodes2.indexOf(o2))) {
                if (i1 < 0) {
                    return 1;
                }
                if (i22 < 0) {
                    return -1;
                }
                return i1 - i22;
            }
            if (o1.isSpeculated() != o2.isSpeculated()) {
                return o1.isSpeculated() ? -1 : 1;
            }
            if (o1.isConstant() != o2.isConstant()) {
                return o1.isConstant() ? -1 : 1;
            }
            Set<@NonNull Node> set1 = this.targetFromSourceClosure.get(o1);
            Set<@NonNull Node> set2 = this.targetFromSourceClosure.get(o2);
            assert (set1 != null && set2 != null);
            int l1 = set1.size();
            int diff = l1 - (l2 = set2.size());
            if (diff != 0) {
                return diff;
            }
            if (o1.isLoaded() != o2.isLoaded()) {
                return o1.isLoaded() ? -1 : 1;
            }
            if (o1.isPredicated() != o2.isPredicated()) {
                return o1.isPredicated() ? -1 : 1;
            }
            boolean c1 = QVTscheduleUtil.getCastTarget((Node)o1) != o1;
            boolean bl = c2 = QVTscheduleUtil.getCastTarget((Node)o2) != o2;
            if (c1 != c2) {
                return !c1 ? -1 : 1;
            }
            int i12 = this.getImplicity(o1);
            diff = i12 - (i2 = this.getImplicity(o2));
            if (diff != 0) {
                return diff;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }

        private int getImplicity(@NonNull Node node) {
            Integer implicity;
            Map<@NonNull Node, @NonNull Integer> node2implicity2 = this.node2implicity;
            if (node2implicity2 == null) {
                this.node2implicity = node2implicity2 = new HashMap<Node, Integer>();
            }
            if ((implicity = node2implicity2.get(node)) == null) {
                implicity = 0;
                for (NavigableEdge e : node.getNavigableEdges()) {
                    if (!e.getProperty().isIsImplicit()) continue;
                    implicity = implicity + 1;
                }
                node2implicity2.put(node, implicity);
            }
            return implicity;
        }
    }
}

