/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.entities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.php.composer.api.entities.JsonCollection;
import org.eclipse.php.composer.api.entities.JsonEntity;

public abstract class AbstractJsonArray<V>
extends JsonEntity
implements JsonCollection,
Iterable<V> {
    protected List<V> values = new LinkedList<V>();
    private transient PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            int index = AbstractJsonArray.this.values.indexOf(e.getSource());
            AbstractJsonArray.this.firePropertyChange("#" + index + "." + e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
    };

    @Override
    protected void doParse(Object obj) {
        this.clear();
        if (obj instanceof List) {
            for (Object item : (List)obj) {
                this.add(item);
            }
        }
    }

    @Override
    protected Object buildJson() {
        LinkedList<Object> out = new LinkedList<Object>();
        for (V val : this.values) {
            if (val == null) continue;
            out.add(this.getJsonValue(val));
        }
        return out;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void clear() {
        while (this.values.size() > 0) {
            this.remove(this.get(0));
        }
    }

    public boolean has(V value) {
        return this.values.contains(value);
    }

    public V get(int index) {
        return this.values.get(index);
    }

    public int indexOf(V value) {
        return this.values.indexOf(value);
    }

    public void add(V value) {
        this.values.add(value);
        if (value instanceof JsonEntity) {
            ((JsonEntity)value).addPropertyChangeListener(this.propListener);
        }
        this.firePropertyChange("#" + (this.values.size() - 1), null, value);
    }

    public void add(int index, V newValue) throws IndexOutOfBoundsException {
        V oldValue = this.values.get(index);
        if (!this.values.subList(index, index + 1).contains(newValue)) {
            this.values.remove(oldValue);
            this.values.add(index, newValue);
            if (oldValue instanceof JsonEntity) {
                ((JsonEntity)oldValue).removePropertyChangeListener(this.propListener);
            }
            if (newValue instanceof JsonEntity) {
                ((JsonEntity)newValue).removePropertyChangeListener(this.propListener);
            }
            this.firePropertyChange("#" + index, oldValue, newValue);
        }
    }

    public void remove(V value) {
        int index = this.values.indexOf(value);
        this.values.remove(value);
        if (value instanceof JsonEntity) {
            ((JsonEntity)value).removePropertyChangeListener(this.propListener);
        }
        this.firePropertyChange("#" + index, value, null);
    }

    public void remove(int index) throws IndexOutOfBoundsException {
        V value = this.values.remove(index);
        if (value instanceof JsonEntity) {
            ((JsonEntity)value).removePropertyChangeListener(this.propListener);
        }
        this.firePropertyChange("#" + index, value, null);
    }

    public Object[] toArray() {
        return this.values.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.values.toArray(a);
    }

    public List<V> toList() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractJsonArray) {
            return this.values.equals(((AbstractJsonArray)obj).toList());
        }
        return false;
    }

    @Override
    public Iterator<V> iterator() {
        return this.values.iterator();
    }
}

