/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractGraphicalParametricAction;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;

public class FontAction
extends AbstractGraphicalParametricAction {
    public FontAction(List<IGraphicalEditPart> selectedElements) {
        super(null, selectedElements);
    }

    protected Command getCommand(ChangePropertyValueRequest req) {
        CompoundCommand cmd = new CompoundCommand("Change value for " + req.getPropertyName());
        for (IGraphicalEditPart editPart : this.getSelection()) {
            cmd.add(editPart.getCommand((Request)req));
        }
        return cmd;
    }

    @Override
    public boolean isEnabled() {
        ChangePropertyValueRequest request = new ChangePropertyValueRequest("Font", "notation.FontStyle.fontColor");
        request.setType((Object)"property_change");
        CompoundCommand command = new CompoundCommand("Font Command");
        for (IGraphicalEditPart current : this.getSelection()) {
            Command tmp = current.getCommand((Request)request);
            if (tmp == null) continue;
            command.add(tmp);
        }
        return !command.isEmpty() && command.size() == this.getSelection().size();
    }

    protected Object getOperationSetPropertyValue(String id) {
        List<IGraphicalEditPart> set = this.getSelection();
        if (!set.isEmpty()) {
            IGraphicalEditPart primaryEditPart = set.get(set.size() - 1);
            return this.getPropertyValue(primaryEditPart, id);
        }
        return null;
    }

    protected Object getPropertyValue(final IGraphicalEditPart editPart, final String thePropertyId) {
        try {
            return editPart.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    this.setResult(FontAction.this.getStructuralFeatureValue(editPart, thePropertyId));
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getPropertyValue", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getPropertyValue", (Throwable)e);
            return null;
        }
    }

    private Object getStructuralFeatureValue(IGraphicalEditPart editpart, String thePropertyId) {
        ENamedElement element = PackageUtil.getElement((String)thePropertyId);
        if (element instanceof EStructuralFeature) {
            if (this.digIntoGroups() && editpart instanceof GroupEditPart) {
                editpart = (IGraphicalEditPart)editpart.getChildren().get(0);
            }
            return editpart.getStructuralFeatureValue((EStructuralFeature)element);
        }
        return null;
    }

    protected boolean digIntoGroups() {
        return true;
    }

    @Override
    protected Command getBuildedCommand() {
        String name = (String)this.getOperationSetPropertyValue(Properties.ID_FONTNAME);
        Integer height = (Integer)this.getOperationSetPropertyValue(Properties.ID_FONTSIZE);
        Boolean bold = (Boolean)this.getOperationSetPropertyValue(Properties.ID_FONTBOLD);
        Boolean italic = (Boolean)this.getOperationSetPropertyValue(Properties.ID_FONTITALIC);
        int style = (bold != false ? 1 : 0) | (italic != false ? 2 : 0);
        FontData initFontData = new FontData(name, height.intValue(), style);
        Integer color = (Integer)this.getOperationSetPropertyValue(Properties.ID_FONTCOLOR);
        RGB initFontColor = FigureUtilities.integerToRGB((Integer)color);
        Shell shell = this.getDiagramGraphicalViewer().getControl().getShell();
        FontDialog fontDialog = new FontDialog(shell);
        fontDialog.setFontList(new FontData[]{initFontData});
        fontDialog.setRGB(initFontColor);
        FontData fData = fontDialog.open();
        RGB fColor = fontDialog.getRGB();
        CompoundCommand cc = new CompoundCommand(DiagramUIActionsMessages.PropertyDescriptorFactory_Font);
        if (fData != null && fColor != null) {
            cc.add(this.getCommand(new ChangePropertyValueRequest(Properties.ID_FONTNAME, Properties.ID_FONTNAME, (Object)fData.getName())));
            cc.add(this.getCommand(new ChangePropertyValueRequest(Properties.ID_FONTSIZE, Properties.ID_FONTSIZE, (Object)new Integer(fData.getHeight()))));
            cc.add(this.getCommand(new ChangePropertyValueRequest(Properties.ID_FONTBOLD, Properties.ID_FONTBOLD, (Object)((fData.getStyle() & 1) != 0 ? 1 : 0))));
            cc.add(this.getCommand(new ChangePropertyValueRequest(Properties.ID_FONTITALIC, Properties.ID_FONTITALIC, (Object)((fData.getStyle() & 2) != 0 ? 1 : 0))));
            cc.add(this.getCommand(new ChangePropertyValueRequest(Properties.ID_FONTCOLOR, Properties.ID_FONTCOLOR, (Object)FigureUtilities.RGBToInteger((RGB)fColor))));
        }
        if (!cc.isEmpty() && cc.canExecute()) {
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }
}

