/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.SyncKind;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.SyncStyles;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.sync.service.AbstractSyncTrigger;
import org.eclipse.papyrus.infra.sync.service.CascadeTriggers;
import org.eclipse.papyrus.infra.sync.service.ISyncAction;
import org.eclipse.papyrus.infra.sync.service.ISyncService;

public class DiagramSyncTrigger
extends AbstractSyncTrigger {
    public ISyncAction trigger(ISyncService syncService, Object object) {
        return new CascadeTriggers(this.synchronizedEditPartsFunction());
    }

    Function<Object, Iterable<?>> synchronizedEditPartsFunction() {
        return new Function<Object, Iterable<?>>(){

            public Iterable<?> apply(Object input) {
                return DiagramSyncTrigger.this.getSynchronizedEditParts(input);
            }
        };
    }

    Iterable<? extends EditPart> getSynchronizedEditParts(Object root) {
        Iterable<Object> result = !(root instanceof EditPartViewer) ? Collections.emptyList() : this.getSynchronizedEditParts((EditPartViewer)root);
        return result;
    }

    Iterable<? extends EditPart> getSynchronizedEditParts(final EditPartViewer viewer) {
        return new Iterable<EditPart>(){

            @Override
            public Iterator<EditPart> iterator() {
                return new AbstractIterator<EditPart>(viewer){
                    TreeIterator<EditPart> delegate;
                    {
                        this.delegate = DiagramEditPartsUtil.getAllContents((EditPart)editPartViewer.getRootEditPart(), false);
                    }

                    protected EditPart computeNext() {
                        while (this.delegate.hasNext()) {
                            EditPart next = (EditPart)this.delegate.next();
                            if (!(next.getModel() instanceof View)) {
                                this.delegate.prune();
                                continue;
                            }
                            if (!DiagramSyncTrigger.this.shouldTrigger((View)next.getModel())) continue;
                            return next;
                        }
                        return (EditPart)this.endOfData();
                    }
                };
            }
        };
    }

    protected boolean shouldTrigger(View view) {
        boolean result = view instanceof Diagram ? true : SyncStyles.getSyncKind(view) != SyncKind.NONE;
        return result;
    }
}

