/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractListeners<L extends IAbstractListener> {
    protected final @NonNull List<@NonNull WeakReference<L>> listeners = new ArrayList<WeakReference<L>>();

    public synchronized void addListener(@NonNull L aListener) {
        for (WeakReference<L> ref : this.listeners) {
            @Nullable IAbstractListener listener = (IAbstractListener)ref.get();
            if (listener != aListener) continue;
            return;
        }
        this.listeners.add(new WeakReference<L>(aListener));
    }

    protected void doFlush() {
        int i = this.listeners.size();
        while (--i >= 0) {
            @Nullable IAbstractListener completeListener = (IAbstractListener)this.listeners.get(i).get();
            if (completeListener != null) continue;
            this.listeners.remove(i);
        }
    }

    public synchronized boolean removeListener(@NonNull L aListener) {
        for (WeakReference<L> ref : this.listeners) {
            @Nullable IAbstractListener listener = (IAbstractListener)ref.get();
            if (listener != aListener) continue;
            this.listeners.remove(ref);
            break;
        }
        this.doFlush();
        return this.listeners.size() <= 0;
    }

    public static interface IAbstractListener {
    }
}

