/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.linux;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.oprofile.core.IOpxmlProvider;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpInfo;
import org.eclipse.linuxtools.internal.oprofile.core.linux.OpxmlRunner;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata.ModelDataProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions.SessionsProcessor;

public class LinuxOpxmlProvider
implements IOpxmlProvider {
    @Override
    public IRunnableWithProgress info(OpInfo info) {
        return new OpInfoRunner(info);
    }

    @Override
    public IRunnableWithProgress modelData(String eventName, String sessionName, OpModelImage image) {
        return monitor -> {
            OpxmlRunner runner = new OpxmlRunner();
            String[] args = new String[]{"model-data", eventName, sessionName};
            ModelDataProcessor.CallData data = new ModelDataProcessor.CallData(image);
            runner.run(args, data);
        };
    }

    @Override
    public IRunnableWithProgress checkEvents(int ctr, String event, int um, int[] eventValid) {
        return monitor -> {
            OpxmlRunner runner = new OpxmlRunner();
            String[] args = new String[]{"check-events", Integer.toString(ctr), event, Integer.toString(um)};
            runner.run(args, eventValid);
        };
    }

    @Override
    public IRunnableWithProgress sessions(ArrayList<OpModelSession> sessionList) {
        return monitor -> {
            OpxmlRunner runner = new OpxmlRunner();
            String[] args = new String[]{"sessions"};
            SessionsProcessor.SessionInfo sinfo = new SessionsProcessor.SessionInfo(sessionList);
            runner.run(args, sinfo);
        };
    }

    public class OpInfoRunner
    implements IRunnableWithProgress {
        private boolean b;
        private final OpInfo info;

        public OpInfoRunner(OpInfo info) {
            this.info = info;
        }

        public boolean run0(IProgressMonitor monitor) {
            this.run(monitor);
            return this.b;
        }

        public void run(IProgressMonitor monitor) {
            OpxmlRunner runner = new OpxmlRunner();
            String[] args = new String[]{"info"};
            this.b = runner.run(args, this.info);
        }
    }
}

