/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.internal.ast.models;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;

public final class LuaDLTKModelUtils {
    private LuaDLTKModelUtils() {
    }

    public static boolean isAncestor(IModelElement element, IModelElement ancestor) {
        return ancestor != null && element != null && (ancestor.equals(element.getParent()) || LuaDLTKModelUtils.isAncestor(element.getParent(), ancestor));
    }

    private static boolean isModule(int flags) {
        return (flags & 0x400) != 0;
    }

    private static boolean isPublic(int flags) {
        return (flags & 0x40) != 0;
    }

    private static boolean isPrivate(int flags) {
        return (flags & 0x10) != 0;
    }

    private static boolean isTable(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isModule(IMember member) throws ModelException {
        return member instanceof IType && LuaDLTKModelUtils.isModule(member.getFlags());
    }

    public static boolean isType(IMember member) throws ModelException {
        return member instanceof IType && LuaDLTKModelUtils.isPublic(member.getFlags());
    }

    public static boolean isModuleFunction(IMember member) throws ModelException {
        return member instanceof IMethod && LuaDLTKModelUtils.isModule(member.getFlags());
    }

    public static boolean isModuleField(IMember member) throws ModelException {
        return member instanceof IField && !LuaDLTKModelUtils.isTable(member.getFlags()) && LuaDLTKModelUtils.isModule(member.getFlags());
    }

    public static boolean isModuleTable(IMember member) throws ModelException {
        return member instanceof IField && LuaDLTKModelUtils.isTable(member.getFlags()) && LuaDLTKModelUtils.isModule(member.getFlags());
    }

    public static boolean isPrivateFunction(IMember member) throws ModelException {
        return member instanceof IMethod && LuaDLTKModelUtils.isPrivate(member.getFlags());
    }

    public static boolean isPrivateField(IMember member) throws ModelException {
        return member instanceof IField && !LuaDLTKModelUtils.isTable(member.getFlags()) && LuaDLTKModelUtils.isPrivate(member.getFlags());
    }

    public static boolean isPrivateTable(IMember member) throws ModelException {
        return member instanceof IField && LuaDLTKModelUtils.isTable(member.getFlags()) && LuaDLTKModelUtils.isPrivate(member.getFlags());
    }

    public static boolean isPublicFunction(IMember member) throws ModelException {
        return member instanceof IMethod && LuaDLTKModelUtils.isPublic(member.getFlags());
    }

    public static boolean isPublicField(IMember member) throws ModelException {
        return member instanceof IField && !LuaDLTKModelUtils.isTable(member.getFlags()) && LuaDLTKModelUtils.isPublic(member.getFlags());
    }

    public static boolean isPublicTable(IMember member) throws ModelException {
        return member instanceof IField && LuaDLTKModelUtils.isTable(member.getFlags()) && LuaDLTKModelUtils.isPublic(member.getFlags());
    }
}

