/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.PerTargetLaunchConfigProvider;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public abstract class ProjectPerTargetLaunchConfigProvider
extends PerTargetLaunchConfigProvider {
    @Override
    public boolean supports(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        return descriptor.getAdapter(IProject.class) != null;
    }

    @Override
    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        super.populateLaunchConfiguration(descriptor, target, workingCopy);
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        IResource[] mappedResources = workingCopy.getMappedResources();
        if (mappedResources == null || mappedResources.length == 0) {
            workingCopy.setMappedResources(new IResource[]{project});
        } else {
            IResource[] newResources = new IResource[mappedResources.length + 1];
            System.arraycopy(mappedResources, 0, newResources, 0, mappedResources.length);
            newResources[mappedResources.length] = project;
            workingCopy.setMappedResources(newResources);
        }
    }

    @Override
    protected ILaunchDescriptor getLaunchDescriptor(ILaunchConfiguration configuration) throws CoreException {
        IResource[] mappedResources = configuration.getMappedResources();
        if (mappedResources == null) {
            return null;
        }
        IProject project = null;
        IResource[] iResourceArray = mappedResources;
        int n = mappedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IProject) {
                project = (IProject)resource;
            }
            ++n2;
        }
        if (project == null) {
            return null;
        }
        ILaunchBarManager manager = Activator.getService(ILaunchBarManager.class);
        return manager.launchObjectAdded(project);
    }
}

