/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.providers;

import org.eclipse.jwt.meta.providers.interfaces.ICommandProvider;
import org.eclipse.jwt.meta.providers.interfaces.IImageProvider;
import org.eclipse.jwt.meta.providers.interfaces.IVisibilityProvider;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.providers.MetaModelCommandProvider;
import org.eclipse.jwt.we.misc.providers.MetaModelImageProvider;
import org.eclipse.jwt.we.misc.providers.MetaModelVisibilityProvider;

public class ProviderInstanceFactory {
    private static ProviderInstanceFactory myinstance;
    private IVisibilityProvider visibilityProvider;
    private IImageProvider imageProvider;

    public static ProviderInstanceFactory getInstance() {
        if (myinstance == null) {
            myinstance = new ProviderInstanceFactory();
        }
        return myinstance;
    }

    public IVisibilityProvider getDefaultVisibilityProvider() {
        if (this.visibilityProvider == null) {
            this.visibilityProvider = new MetaModelVisibilityProvider();
        }
        return this.visibilityProvider;
    }

    public IImageProvider getDefaultImageProvider() {
        if (this.imageProvider == null) {
            this.imageProvider = new MetaModelImageProvider();
        }
        return this.imageProvider;
    }

    public ICommandProvider getDefaultCommandProvider(WEEditor weeditor) {
        return new MetaModelCommandProvider(weeditor);
    }
}

