/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.logging.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.eclipse.swt.widgets.Text;

public class TextFormatter
extends Formatter {
    private static final String datePattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Date date = new Date();
    private String lineSeparator = Text.DELIMITER;

    public String format(LogRecord record) {
        StringBuffer text = new StringBuffer();
        this.date.setTime(record.getMillis());
        text.append(dateFormatter.format(this.date));
        text.append(" ");
        if (record.getSourceClassName() != null) {
            text.append(record.getSourceClassName());
        } else {
            text.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            text.append(" ");
            text.append(record.getSourceMethodName());
        }
        text.append(this.lineSeparator);
        text.append("  ");
        text.append(record.getLevel().getName());
        if (record.getMessage() != null) {
            text.append(": ");
            String message = this.formatMessage(record);
            text.append(message);
        }
        if (record.getThrown() != null) {
            text.append(" (");
            text.append(String.valueOf(record.getThrown().getClass().getName()) + ": " + record.getThrown().getMessage());
            text.append(")");
        }
        text.append(this.lineSeparator);
        return text.toString();
    }
}

