/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.lib;

import java.text.MessageFormat;
import org.eclipse.jgit.lfs.errors.InvalidLongObjectIdException;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public class MutableLongObjectId
extends AnyLongObjectId {
    public MutableLongObjectId() {
    }

    MutableLongObjectId(MutableLongObjectId src) {
        this.fromObjectId(src);
    }

    public void setByte(int index, int value) {
        switch (index >> 3) {
            case 0: {
                this.w1 = MutableLongObjectId.set(this.w1, index & 7, value);
                break;
            }
            case 1: {
                this.w2 = MutableLongObjectId.set(this.w2, index & 7, value);
                break;
            }
            case 2: {
                this.w3 = MutableLongObjectId.set(this.w3, index & 7, value);
                break;
            }
            case 3: {
                this.w4 = MutableLongObjectId.set(this.w4, index & 7, value);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
    }

    private static long set(long w, int index, long value) {
        value &= 0xFFL;
        switch (index) {
            case 0: {
                return w & 0xFFFFFFFFFFFFFFL | value << 56;
            }
            case 1: {
                return w & 0xFF00FFFFFFFFFFFFL | value << 48;
            }
            case 2: {
                return w & 0xFFFF00FFFFFFFFFFL | value << 40;
            }
            case 3: {
                return w & 0xFFFFFF00FFFFFFFFL | value << 32;
            }
            case 4: {
                return w & 0xFFFFFFFF00FFFFFFL | value << 24;
            }
            case 5: {
                return w & 0xFFFFFFFFFF00FFFFL | value << 16;
            }
            case 6: {
                return w & 0xFFFFFFFFFFFF00FFL | value << 8;
            }
            case 7: {
                return w & 0xFFFFFFFFFFFFFF00L | value;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void clear() {
        this.w1 = 0L;
        this.w2 = 0L;
        this.w3 = 0L;
        this.w4 = 0L;
    }

    public void fromObjectId(AnyLongObjectId src) {
        this.w1 = src.w1;
        this.w2 = src.w2;
        this.w3 = src.w3;
        this.w4 = src.w4;
    }

    public void fromRaw(byte[] bs) {
        this.fromRaw(bs, 0);
    }

    public void fromRaw(byte[] bs, int p) {
        this.w1 = NB.decodeInt64((byte[])bs, (int)p);
        this.w2 = NB.decodeInt64((byte[])bs, (int)(p + 8));
        this.w3 = NB.decodeInt64((byte[])bs, (int)(p + 16));
        this.w4 = NB.decodeInt64((byte[])bs, (int)(p + 24));
    }

    public void fromRaw(long[] longs) {
        this.fromRaw(longs, 0);
    }

    public void fromRaw(long[] longs, int p) {
        this.w1 = longs[p];
        this.w2 = longs[p + 1];
        this.w3 = longs[p + 2];
        this.w4 = longs[p + 3];
    }

    public void fromString(byte[] buf, int offset) {
        this.fromHexString(buf, offset);
    }

    public void fromString(String str) {
        if (str.length() != 64) {
            throw new IllegalArgumentException(MessageFormat.format(LfsText.get().invalidLongId, str));
        }
        this.fromHexString(Constants.encodeASCII((String)str), 0);
    }

    private void fromHexString(byte[] bs, int p) {
        try {
            this.w1 = RawParseUtils.parseHexInt64((byte[])bs, (int)p);
            this.w2 = RawParseUtils.parseHexInt64((byte[])bs, (int)(p + 16));
            this.w3 = RawParseUtils.parseHexInt64((byte[])bs, (int)(p + 32));
            this.w4 = RawParseUtils.parseHexInt64((byte[])bs, (int)(p + 48));
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new InvalidLongObjectIdException(bs, p, 64);
        }
    }

    @Override
    public LongObjectId toObjectId() {
        return new LongObjectId(this);
    }
}

