/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.util.regex.Pattern;
import org.eclipse.dltk.debug.ui.ScriptDebugConsoleTracker;
import org.eclipse.dltk.debug.ui.ScriptDebuggerConsoleToFileHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.PatternMatchEvent;

public class ScriptDebugConsoleTraceTracker
extends ScriptDebugConsoleTracker {
    private Pattern pattern;
    private final String patternString;

    public ScriptDebugConsoleTraceTracker() {
        this.patternString = "\\t*#\\d+ +file:(.*) \\[(\\d+)\\]";
    }

    public ScriptDebugConsoleTraceTracker(String patternString) {
        this.patternString = patternString;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset();
            int length = event.getLength();
            ScriptDebuggerConsoleToFileHyperlink link = new ScriptDebuggerConsoleToFileHyperlink(this.console, this.getPatternInstance());
            this.console.addHyperlink((IHyperlink)link, link.computeOffset(offset, length, this.console), link.computeLength(offset, length, this.console));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private Pattern getPatternInstance() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.getPattern(), this.getCompilerFlags());
        }
        return this.pattern;
    }

    public String getPattern() {
        return this.patternString;
    }
}

