/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

public class RowColumnLayout
extends AbstractLayout {
    protected Map<IFigure, Object> constraints = new HashMap<IFigure, Object>();
    private static final int MIN_WIDTH_HEIGHT = 30;
    private int totalHeight;
    private int totalWidth;
    private Rectangle region;
    private int[] rowHeights;
    private int[] colWidths;
    boolean spanned = false;
    private int gridWidth;
    private int gridHeight;
    private int[] widthOffsets;
    private int[] heightOffsets;
    private int rows = 0;
    private int cols = 0;
    private boolean debugThis = false;

    public int getNumberOfColumns() {
        return this.cols;
    }

    public int getNumberOfRows() {
        return this.rows;
    }

    public boolean isSpanned() {
        return this.spanned;
    }

    public void setSpanned(boolean spanned) {
        this.spanned = spanned;
    }

    private Rectangle getChildRegion(IFigure f, int availableX, int availableY) {
        if (this.spanned) {
            Dimension sz = f.getPreferredSize();
            int w = (int)Math.round((double)((float)sz.width / (float)this.gridWidth) + 0.5);
            int h = (int)Math.round((double)((float)sz.height / (float)this.gridHeight) + 0.5);
            return new Rectangle(availableX, availableY, w, h);
        }
        return new Rectangle(availableX, availableY, 1, 1);
    }

    public void characterizeGrid(IFigure f) {
        Rectangle r;
        IFigure child;
        this.initVars();
        this.region = new Rectangle(0, 0, -1, -1);
        int unresolved = 0;
        ListIterator children = f.getChildren().listIterator();
        while (children.hasNext()) {
            child = (IFigure)children.next();
            r = (Rectangle)this.constraints.get(child);
            if (r == null || r.width < 0 || r.height < 0) {
                ++unresolved;
                if (!this.debugThis) continue;
                if (r != null) {
                    System.out.println("unresolved figure " + r + " " + child);
                    continue;
                }
                System.out.println("unresolved figure " + child);
                continue;
            }
            if (this.debugThis) {
                System.out.println("resolved figure " + r + " " + child);
            }
            if (this.region.height < 0) {
                this.region.setBounds(r);
                continue;
            }
            this.region.union(r);
        }
        if (this.region.height >= 0) {
            this.rows = this.region.getBottomRight().y;
            this.cols = this.region.getBottomRight().x;
        }
        if (unresolved > 0) {
            children = f.getChildren().listIterator();
            while (children.hasNext()) {
                child = (IFigure)children.next();
                r = (Rectangle)this.constraints.get(child);
                if (r != null && r.width >= 0 && r.height >= 0) continue;
                if (this.debugThis) {
                    System.out.println("trying to resolve figure at " + child);
                }
                r = this.getChildRegion(child, this.cols, 0);
                this.constraints.put(child, r);
                if (this.debugThis) {
                    System.out.println("new rect " + r);
                }
                if (this.region.height < 0) {
                    this.region.setBounds(r);
                } else {
                    this.region.union(r);
                }
                this.cols = this.region.getBottomRight().x;
            }
        }
        if (this.region.x < 0) {
            return;
        }
        this.rows = this.region.getBottomRight().y;
        this.cols = this.region.getBottomRight().x;
        if (this.rows < 0) {
            return;
        }
        if (this.debugThis) {
            System.out.println("bounds  " + this.region);
            System.out.println("rows " + this.rows);
            System.out.println("cols " + this.cols);
        }
        this.rowHeights = new int[this.rows];
        this.colWidths = new int[this.cols];
        int i = 0;
        while (i < this.cols) {
            this.colWidths[i] = 30;
            ++i;
        }
        i = 0;
        while (i < this.rows) {
            this.rowHeights[i] = 30;
            ++i;
        }
        if (!this.isSpanned()) {
            children = f.getChildren().listIterator();
            while (children.hasNext()) {
                IFigure child2 = (IFigure)children.next();
                Rectangle rowcol = (Rectangle)this.constraints.get(child2);
                if (this.debugThis) {
                    System.out.println("child " + child2 + " " + rowcol);
                }
                Dimension sz = this.getChildSize(child2, -1, -1);
                if (rowcol.x >= this.cols || rowcol.y >= this.rows) {
                    throw new IllegalArgumentException();
                }
                if (rowcol.x < 0 || rowcol.y < 0) {
                    throw new IllegalArgumentException();
                }
                this.rowHeights[rowcol.y] = Math.max(this.rowHeights[rowcol.y], sz.height + 10);
                this.colWidths[rowcol.x] = Math.max(this.colWidths[rowcol.x], sz.width + 10);
            }
        }
        i = 0;
        while (i < this.rows) {
            this.totalHeight += this.rowHeights[i];
            ++i;
        }
        i = 0;
        while (i < this.cols) {
            this.totalWidth += this.colWidths[i];
            ++i;
        }
        this.widthOffsets = new int[this.cols];
        this.heightOffsets = new int[this.rows];
        i = 1;
        while (i < this.cols) {
            this.widthOffsets[i] = this.colWidths[i - 1] + this.widthOffsets[i - 1];
            ++i;
        }
        i = 1;
        while (i < this.rows) {
            this.heightOffsets[i] = this.rowHeights[i - 1] + this.heightOffsets[i - 1];
            ++i;
        }
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        return child.getPreferredSize(wHint, hHint);
    }

    public Object getConstraint(IFigure figure) {
        return this.constraints.get(figure);
    }

    public Point getOrigin(IFigure parent) {
        return parent.getClientArea().getLocation();
    }

    private void initVars() {
        this.totalHeight = 0;
        this.totalWidth = 0;
        this.rowHeights = null;
        this.colWidths = null;
        this.gridWidth = 40;
        this.gridHeight = 40;
        this.widthOffsets = null;
        this.heightOffsets = null;
        this.rows = 0;
        this.cols = 0;
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
        if (this.debugThis && newConstraint != null) {
            System.out.println("setConstraint(" + figure + " " + newConstraint + ")");
        }
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        this.characterizeGrid(container);
        Dimension prefSize = new Dimension();
        prefSize.height += this.totalHeight;
        prefSize.width += this.totalWidth;
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    public void layout(IFigure parent) {
        this.characterizeGrid(parent);
        if (this.rows == 0 || this.cols == 0) {
            return;
        }
        Point offset = this.getOrigin(parent);
        Point centeringOffset = new Point();
        for (IFigure f : parent.getChildren()) {
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (bounds == null) continue;
            if (this.debugThis) {
                System.out.println("bounds  " + f + " " + bounds);
            }
            Rectangle newChildArea = new Rectangle();
            int row = bounds.y;
            int col = bounds.x;
            newChildArea.x = this.widthOffsets[col];
            newChildArea.y = this.heightOffsets[row];
            if (this.isSpanned()) {
                newChildArea.height = this.gridHeight * bounds.height;
                newChildArea.width = this.gridWidth * bounds.width;
            } else {
                newChildArea.height = this.rowHeights[row];
                newChildArea.width = this.colWidths[col];
            }
            centeringOffset.x = (newChildArea.width - f.getPreferredSize().width) / 2;
            centeringOffset.y = (newChildArea.height - f.getPreferredSize().height) / 2;
            newChildArea = newChildArea.getTranslated(offset);
            newChildArea = newChildArea.getTranslated(centeringOffset);
            newChildArea.width = f.getPreferredSize().width;
            newChildArea.height = f.getPreferredSize().height;
            f.setBounds(newChildArea);
        }
    }

    public boolean getGridInfoFromLocation(Point pt, Rectangle gridInfo, Rectangle pixRegion) {
        Rectangle hitTest = new Rectangle();
        int i = 0;
        while (i < this.cols) {
            int k = 0;
            while (k < this.rows) {
                hitTest.x = this.widthOffsets[i];
                hitTest.y = this.heightOffsets[k];
                hitTest.width = this.colWidths[i];
                hitTest.height = this.rowHeights[k];
                if (hitTest.contains(pt)) {
                    gridInfo.x = i;
                    gridInfo.y = k;
                    gridInfo.setSize(1, 1);
                    pixRegion.setBounds(hitTest);
                    return true;
                }
                ++k;
            }
            ++i;
        }
        return false;
    }

    public boolean isDroppableAt(EditPart parentPart, EditPart test, Rectangle gridInfo) {
        IFigure f = ((GraphicalEditPart)parentPart).getContentPane();
        ListIterator children = f.getChildren().listIterator();
        while (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            Rectangle r = (Rectangle)this.constraints.get(child);
            if (!r.getLocation().equals((Object)gridInfo.getLocation())) continue;
            return false;
        }
        return true;
    }

    public Rectangle[] getDividers() {
        if (this.rows <= 1 && this.cols <= 1) {
            return null;
        }
        Rectangle[] rects = new Rectangle[this.rows - 1 + (this.cols - 1)];
        int n = 0;
        int i = 0;
        while (i < this.cols - 1) {
            rects[n++] = new Rectangle(new Point(this.widthOffsets[i + 1], 0), new Dimension(0, this.totalHeight));
            ++i;
        }
        i = 0;
        while (i < this.rows - 1) {
            rects[n++] = new Rectangle(new Point(0, this.heightOffsets[i + 1]), new Dimension(this.totalWidth, 0));
            ++i;
        }
        return rects;
    }
}

