/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.jointdataset;

import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.jointdataset.JointDataSetUtil;
import org.eclipse.birt.data.engine.impl.jointdataset.SegmentInfo;

class BinaryTreeROSeekerHelper {
    private Node rootNode;
    private Node latestNode;

    BinaryTreeROSeekerHelper(List segmentInfoList) {
        this.rootNode = this.populateNode(segmentInfoList);
    }

    SegmentInfo search(Object[] o) throws DataException {
        Node n;
        if (this.latestNode != null && JointDataSetUtil.compare(o, this.latestNode.getSegmentInfo().getMinValue()) >= 0 && JointDataSetUtil.compare(o, this.latestNode.getSegmentInfo().getMaxValue()) <= 0) {
            return this.latestNode.getSegmentInfo();
        }
        this.latestNode = n = this.findNodeWithValue(o, this.rootNode);
        return n == null ? null : n.getSegmentInfo();
    }

    private Node populateNode(List list) {
        int index = list.size() / 2;
        if (index >= list.size()) {
            return null;
        }
        Node n = new Node((SegmentInfo)list.get(index));
        List left = list.subList(0, index);
        List right = list.subList(index + 1, list.size());
        n.setLeftChild(left.size() == 0 ? null : this.populateNode(left));
        n.setRightChild(right.size() == 0 ? null : this.populateNode(right));
        return n;
    }

    private Node findNodeWithValue(Object[] o, Node node) throws DataException {
        int compareMin = JointDataSetUtil.compare(o, node.getSegmentInfo().getMinValue());
        int compareMax = JointDataSetUtil.compare(o, node.getSegmentInfo().getMaxValue());
        if (compareMin >= 0 && compareMax <= 0) {
            return node;
        }
        if (compareMin < 0 && node.getLeftChild() != null) {
            return this.findNodeWithValue(o, node.getLeftChild());
        }
        if (compareMax > 0 && node.getRightChild() != null) {
            return this.findNodeWithValue(o, node.getRightChild());
        }
        return null;
    }

    private static class Node {
        private Node leftChild;
        private Node rightChild;
        private SegmentInfo sinfo;

        private Node(SegmentInfo sinfo) {
            this.sinfo = sinfo;
        }

        private SegmentInfo getSegmentInfo() {
            return this.sinfo;
        }

        private Node getLeftChild() {
            return this.leftChild;
        }

        private Node getRightChild() {
            return this.rightChild;
        }

        private void setLeftChild(Node leftChild) {
            if (leftChild == null) {
                return;
            }
            this.leftChild = leftChild;
        }

        private void setRightChild(Node rightChild) {
            if (rightChild == null) {
                return;
            }
            this.rightChild = rightChild;
        }
    }
}

