/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

class BinaryDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private PagedMutable docs;
    private PagedGrowableWriter offsets;
    private PagedGrowableWriter lengths;
    private BytesRefBuilder values;
    private int size;
    private final int bitsPerValue;

    public BinaryDocValuesFieldUpdates(long delGen, String field, int maxDoc) {
        super(maxDoc, delGen, field, DocValuesType.BINARY);
        this.bitsPerValue = PackedInts.bitsRequired(maxDoc - 1);
        this.docs = new PagedMutable(1L, 1024, this.bitsPerValue, 0.0f);
        this.offsets = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.lengths = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.values = new BytesRefBuilder();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public synchronized void add(int doc, Object value) {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        assert (doc < this.maxDoc) : "doc=" + doc + " maxDoc=" + this.maxDoc;
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
        }
        BytesRef val = (BytesRef)value;
        if (this.docs.size() == (long)this.size) {
            this.docs = (PagedMutable)this.docs.grow(this.size + 1);
            this.offsets = (PagedGrowableWriter)this.offsets.grow(this.size + 1);
            this.lengths = (PagedGrowableWriter)this.lengths.grow(this.size + 1);
        }
        this.docs.set(this.size, doc);
        this.offsets.set(this.size, this.values.length());
        this.lengths.set(this.size, val.length);
        this.values.append(val);
        ++this.size;
    }

    @Override
    public void finish() {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if ((long)this.size < this.docs.size()) {
            this.docs = (PagedMutable)this.docs.resize(this.size);
            this.offsets = (PagedGrowableWriter)this.offsets.resize(this.size);
            this.lengths = (PagedGrowableWriter)this.lengths.resize(this.size);
        }
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                long tmpDoc = BinaryDocValuesFieldUpdates.this.docs.get(j);
                BinaryDocValuesFieldUpdates.this.docs.set(j, BinaryDocValuesFieldUpdates.this.docs.get(i));
                BinaryDocValuesFieldUpdates.this.docs.set(i, tmpDoc);
                long tmpOffset = BinaryDocValuesFieldUpdates.this.offsets.get(j);
                BinaryDocValuesFieldUpdates.this.offsets.set(j, BinaryDocValuesFieldUpdates.this.offsets.get(i));
                BinaryDocValuesFieldUpdates.this.offsets.set(i, tmpOffset);
                long tmpLength = BinaryDocValuesFieldUpdates.this.lengths.get(j);
                BinaryDocValuesFieldUpdates.this.lengths.set(j, BinaryDocValuesFieldUpdates.this.lengths.get(i));
                BinaryDocValuesFieldUpdates.this.lengths.set(i, tmpLength);
            }

            @Override
            protected int compare(int i, int j) {
                return Integer.compare((int)BinaryDocValuesFieldUpdates.this.docs.get(i), (int)BinaryDocValuesFieldUpdates.this.docs.get(j));
            }
        }.sort(0, this.size);
    }

    @Override
    public Iterator iterator() {
        if (!this.finished) {
            throw new IllegalStateException("call finish first");
        }
        return new Iterator(this.size, this.offsets, this.lengths, this.docs, this.values.get(), this.delGen);
    }

    @Override
    public boolean any() {
        return this.size > 0;
    }

    @Override
    public long ramBytesUsed() {
        return this.offsets.ramBytesUsed() + this.lengths.ramBytesUsed() + this.docs.ramBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16L + (long)(5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + (long)this.values.bytes().length;
    }

    static final class Iterator
    extends DocValuesFieldUpdates.Iterator {
        private final int size;
        private final PagedGrowableWriter offsets;
        private final PagedGrowableWriter lengths;
        private final PagedMutable docs;
        private long idx = 0L;
        private int doc = -1;
        private final BytesRef value;
        private int offset;
        private int length;
        private final long delGen;

        Iterator(int size, PagedGrowableWriter offsets, PagedGrowableWriter lengths, PagedMutable docs, BytesRef values, long delGen) {
            this.offsets = offsets;
            this.size = size;
            this.lengths = lengths;
            this.docs = docs;
            this.value = values.clone();
            this.delGen = delGen;
        }

        @Override
        BytesRef value() {
            this.value.offset = this.offset;
            this.value.length = this.length;
            return this.value;
        }

        @Override
        int nextDoc() {
            if (this.idx >= (long)this.size) {
                this.offset = -1;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && this.docs.get(this.idx) == (long)this.doc) {
                ++this.idx;
            }
            long prevIdx = this.idx - 1L;
            this.offset = (int)this.offsets.get(prevIdx);
            this.length = (int)this.lengths.get(prevIdx);
            return this.doc;
        }

        @Override
        int doc() {
            return this.doc;
        }

        @Override
        long delGen() {
            return this.delGen;
        }
    }
}

