/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapCollectionExtractorBase
implements IMapExtractor {
    protected final String keyField;
    protected final String valueField;

    public MapCollectionExtractorBase(String keyField, String valueField) {
        this.keyField = keyField;
        this.valueField = valueField;
    }

    @Override
    public boolean hasCapacity() {
        return this.hasExtractableArray();
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        IObjectArray table = this.extractEntries(coll);
        return table == null ? null : Integer.valueOf(table.getLength());
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject coll) {
        try {
            return new MapEntryIterator(coll.getSnapshot(), coll, this.extractEntryIds(coll));
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    protected IObject getEntryKey(IObject obj) {
        try {
            IObject ret = (IObject)obj.resolveValue(this.keyField);
            if (ret != null) {
                return ret;
            }
            return null;
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    protected IObject getEntryValue(IObject obj) {
        try {
            return (IObject)obj.resolveValue(this.valueField);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEntryIterator
    implements Iterator<Map.Entry<IObject, IObject>> {
        private final ISnapshot snapshot;
        private final int[] ids;
        private int idx;
        private IObject coll;

        public MapEntryIterator(ISnapshot snapshot, IObject coll, int[] ids) {
            this.snapshot = snapshot;
            this.ids = ids;
            this.idx = 0;
            this.coll = coll;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.ids.length;
        }

        @Override
        public Map.Entry<IObject, IObject> next() {
            try {
                IObject obj = this.snapshot.getObject(this.ids[this.idx++]);
                return new IMapExtractor.EntryObject(this.coll, MapCollectionExtractorBase.this.getEntryKey(obj), MapCollectionExtractorBase.this.getEntryValue(obj));
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

