package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.recordlabel.Field;
import org.eclipse.gef.dot.internal.language.recordlabel.FieldID;
import org.eclipse.gef.dot.internal.language.recordlabel.RLabel;
import org.eclipse.gef.dot.internal.language.recordlabel.RecordlabelPackage;
import org.eclipse.gef.dot.internal.language.services.DotRecordLabelGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

@SuppressWarnings("all")
public class DotRecordLabelSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotRecordLabelGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == RecordlabelPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case RecordlabelPackage.FIELD:
				if(context == grammarAccess.getFieldRule()) {
					sequence_Field(context, (Field) semanticObject); 
					return; 
				}
				else break;
			case RecordlabelPackage.FIELD_ID:
				if(context == grammarAccess.getFieldIDRule()) {
					sequence_FieldID(context, (FieldID) semanticObject); 
					return; 
				}
				else break;
			case RecordlabelPackage.RLABEL:
				if(context == grammarAccess.getRLabelRule()) {
					sequence_RLabel(context, (RLabel) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     ((portNamed?='<' port=String?)? name=String?)
	 */
	protected void sequence_FieldID(EObject context, FieldID semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (fieldID=FieldID | label=RLabel)
	 */
	protected void sequence_Field(EObject context, Field semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (fields+=Field fields+=Field*)
	 */
	protected void sequence_RLabel(EObject context, RLabel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
