/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.custom;

import static org.eclipse.epp.logging.aeri.core.util.Logs.log;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CustomProcessorDescriptor extends ProcessorDescriptorImpl {
    @Nullable
    private Image icon16;

    protected CustomProcessorDescriptor() {
    }

    @Override
    public synchronized Image getImage16() {
        if (icon16 == null) {
            icon16 = loadImage(getIcon16());
        }
        return icon16;
    }

    private Image loadImage(String path) {
        try {
            return AbstractUIPlugin.imageDescriptorFromPlugin(getContributor(), path).createImage();
        } catch (Exception e) {
            log(new LogMessages(IStatus.ERROR, "Processor \u2018{0}\u2019 failed with exception {1}"), e, getClass(), e.getMessage());
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
    }
}
