/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientEntry;
import org.eclipse.ecf.internal.example.collab.CollabClient;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class SetSharedEditorSelectionAction
implements IEditorActionDelegate {
    ITextEditor editor = null;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        action.setEnabled(false);
        if (targetEditor instanceof ITextEditor) {
            this.editor = (ITextEditor)targetEditor;
            action.setEnabled(true);
        }
    }

    protected IFile getFileForPart(ITextEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            return fei.getFile();
        }
        return null;
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected ClientEntry isConnected(IResource res) {
        if (res == null) {
            return null;
        }
        CollabClient client = CollabClient.getDefault();
        ClientEntry entry = client.isConnected(res, "ecf.generic.client");
        return entry;
    }

    public void run(IAction action) {
        if (this.editor == null) {
            return;
        }
        ISelection s = this.editor.getSelectionProvider().getSelection();
        ITextSelection textSelection = null;
        if (s instanceof ITextSelection) {
            textSelection = (ITextSelection)s;
        }
        if (textSelection == null) {
            return;
        }
        IFile file = this.getFileForPart(this.editor);
        if (file == null) {
            return;
        }
        IProject project = file.getProject();
        ClientEntry entry = this.isConnected((IResource)project.getWorkspace().getRoot());
        if (entry == null) {
            MessageDialog.openInformation((Shell)this.getWorkbench().getDisplay().getActiveShell(), (String)Messages.SetSharedEditorSelectionAction_DIALOG_NOT_CONNECTED_TITLE, (String)Messages.SetSharedEditorSelectionAction_DIALOG_NOT_CONNECTED_TEXT);
            return;
        }
        EclipseCollabSharedObject collabsharedobject = entry.getSharedObject();
        if (collabsharedobject != null) {
            collabsharedobject.sendOpenAndSelectForFile(null, String.valueOf(project.getName()) + "/" + file.getProjectRelativePath().toString(), textSelection.getOffset(), textSelection.getLength());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

