/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.nattable.group.ColumnGroupModel;
import net.sourceforge.nattable.group.command.GroupColumnReorderCommandHandler;
import net.sourceforge.nattable.group.command.GroupMultiColumnReorderCommandHandler;
import net.sourceforge.nattable.group.command.ReorderColumnGroupCommandHandler;
import net.sourceforge.nattable.group.command.ReorderColumnsAndGroupsCommandHandler;
import net.sourceforge.nattable.layer.AbstractLayerTransform;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.reorder.command.MultiColumnReorderCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnGroupReorderLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private IUniqueIndexLayer underlyingLayer;
    private final ColumnGroupModel model;

    public ColumnGroupReorderLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        this.setUnderlyingLayer(underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.model = model;
        this.registerCommandHandler(new ReorderColumnGroupCommandHandler(this));
        this.registerCommandHandler(new ReorderColumnsAndGroupsCommandHandler(this));
        this.registerCommandHandler(new GroupColumnReorderCommandHandler(this));
        this.registerCommandHandler(new GroupMultiColumnReorderCommandHandler(this));
    }

    public boolean reorderColumnGroup(int fromColumnPosition, int toColumnPosition) {
        int fromColumnIndex = this.underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
        List<Integer> fromColumnPositions = this.getColumnGroupPositions(fromColumnIndex);
        return this.underlyingLayer.doCommand(new MultiColumnReorderCommand(this, fromColumnPositions, toColumnPosition));
    }

    public ColumnGroupModel getModel() {
        return this.model;
    }

    @Override
    public ILayer getUnderlyingLayer() {
        return super.getUnderlyingLayer();
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlyingLayer.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.underlyingLayer.getRowPositionByIndex(rowIndex);
    }

    public List<Integer> getColumnGroupPositions(int fromColumnIndex) {
        List<Integer> fromColumnIndexes = this.model.getColumnIndexesInGroup(fromColumnIndex);
        ArrayList<Integer> fromColumnPositions = new ArrayList<Integer>();
        for (Integer columnIndex : fromColumnIndexes) {
            fromColumnPositions.add(this.underlyingLayer.getColumnPositionByIndex(columnIndex));
        }
        Collections.sort(fromColumnPositions);
        return fromColumnPositions;
    }
}

