/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.columnCategories;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.nattable.columnCategories.Node;
import net.sourceforge.nattable.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree
implements Serializable {
    private static final long serialVersionUID = 6182L;
    private Node rootElement;

    public Node getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(Node rootElement) {
        this.rootElement = rootElement;
    }

    public List<Node> toList() {
        ArrayList<Node> list = new ArrayList<Node>();
        this.walk(this.rootElement, list);
        return list;
    }

    public String toString() {
        return this.toList().toString();
    }

    private void walk(Node element, List<Node> list) {
        list.add(element);
        for (Node data : element.getChildren()) {
            this.walk(data, list);
        }
    }

    public Node find(String nodeData) {
        return this.find(this.getRootElement(), nodeData);
    }

    public Node find(Node element, String nodeData) {
        if (nodeData.equals(element.getData())) {
            return element;
        }
        for (Node data : element.getChildren()) {
            Node result = this.find(data, nodeData);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void clear() {
        this.rootElement = null;
    }

    public boolean remove(String nodeData) {
        Node nodeToRemove = this.find(nodeData);
        if (ObjectUtils.isNotNull(nodeToRemove)) {
            nodeToRemove.getParent().getChildren().remove(nodeToRemove);
            nodeToRemove.setParent(null);
            return true;
        }
        return false;
    }
}

