/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContextListener;
import org.eclipse.viatra.query.runtime.matchers.context.IndexingService;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.scopes.TabularRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;

public class SimpleRuntimeContext
extends TabularRuntimeContext {
    private IQueryMetaContext metaContext;

    public SimpleRuntimeContext(IQueryMetaContext metaContext) {
        this.metaContext = metaContext;
    }

    @Override
    public void logError(String message) {
        System.err.println(message);
    }

    @Override
    public IQueryMetaContext getMetaContext() {
        return this.metaContext;
    }

    @Override
    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public boolean isCoalescing() {
        return false;
    }

    @Override
    public boolean isIndexed(IInputKey key, IndexingService service) {
        return this.peekIndexTable(key) != null;
    }

    @Override
    public void ensureIndexed(IInputKey key, IndexingService service) {
        if (this.peekIndexTable(key) == null) {
            throw new IllegalArgumentException(key.getPrettyPrintableName());
        }
    }

    @Override
    public void addUpdateListener(IInputKey key, Tuple seed, IQueryRuntimeContextListener listener) {
    }

    @Override
    public void removeUpdateListener(IInputKey key, Tuple seed, IQueryRuntimeContextListener listener) {
    }

    @Override
    public Object wrapElement(Object externalElement) {
        return externalElement;
    }

    @Override
    public Object unwrapElement(Object internalElement) {
        return internalElement;
    }

    @Override
    public Tuple wrapTuple(Tuple externalElements) {
        return externalElements;
    }

    @Override
    public Tuple unwrapTuple(Tuple internalElements) {
        return internalElements;
    }

    @Override
    public void ensureWildcardIndexing(IndexingService service) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeAfterTraversal(Runnable runnable) throws InvocationTargetException {
        runnable.run();
    }

    @Override
    protected boolean isContainedInStatelessKey(IInputKey key, ITuple seed) {
        if (key instanceof JavaTransitiveInstancesKey) {
            Class<?> instanceClass = this.forceGetWrapperInstanceClass((JavaTransitiveInstancesKey)key);
            return instanceClass != null && instanceClass.isInstance(seed.get(0));
        }
        throw new IllegalArgumentException(key.getPrettyPrintableName());
    }

    private Class<?> forceGetWrapperInstanceClass(JavaTransitiveInstancesKey key) {
        Class<?> instanceClass;
        try {
            instanceClass = key.forceGetWrapperInstanceClass();
        }
        catch (ClassNotFoundException e) {
            this.logError("Could not load instance class for type constraint " + (String)key.getWrappedKey() + ": " + e.getMessage());
            instanceClass = null;
        }
        return instanceClass;
    }
}

