/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.DeleteEObjectTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.helper.task.AbstractCompoundTask;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Messages;

public class DeleteWithoutToolTask
extends AbstractCompoundTask {
    private DRepresentationElement element;
    private Set<EObject> semanticElements;
    private ModelAccessor modelAccessor;
    private TaskHelper taskHelper;

    public DeleteWithoutToolTask(DRepresentationElement element, Set<EObject> semanticElements, ModelAccessor modelAccessor, TaskHelper taskHelper) {
        this.element = element;
        this.semanticElements = semanticElements;
        this.modelAccessor = modelAccessor;
        this.taskHelper = taskHelper;
    }

    public DeleteWithoutToolTask(DRepresentationElement element, ModelAccessor modelAccessor, TaskHelper taskHelper) {
        this.element = element;
        this.modelAccessor = modelAccessor;
        this.taskHelper = taskHelper;
    }

    @Override
    public String getLabel() {
        return Messages.DeleteWithoutToolTask_label;
    }

    @Override
    protected List<ICommandTask> prepareSubTasks() {
        ArrayList<ICommandTask> subTasks = new ArrayList<ICommandTask>();
        Option<DRepresentation> parentRepresentation = new EObjectQuery(this.element).getRepresentation();
        if (parentRepresentation.some()) {
            if (this.semanticElements == null) {
                EObject semanticElement = this.element.getTarget();
                this.semanticElements = semanticElement == null ? Collections.emptySet() : Collections.singleton(semanticElement);
            }
            Set<DSemanticDecorator> diagramElements = this.taskHelper.getDElementToClearFromSemanticElements((EObject)parentRepresentation.get(), this.getAllSemanticElements());
            for (DSemanticDecorator decorator : diagramElements) {
                subTasks.add(new DeleteEObjectTask(decorator, this.modelAccessor));
                this.addDialectSpecificAdditionalDeleteSubTasks(decorator, subTasks);
            }
        }
        for (EObject semantic : this.semanticElements) {
            DeleteEObjectTask deleteSemanticElementTask = new DeleteEObjectTask(semantic, this.modelAccessor);
            subTasks.add(deleteSemanticElementTask);
        }
        return subTasks;
    }

    protected void addDialectSpecificAdditionalDeleteSubTasks(DSemanticDecorator decorator, List<ICommandTask> subTasks) {
    }

    private Set<EObject> getAllSemanticElements() {
        HashSet result = Sets.newHashSet(this.semanticElements);
        for (EObject sem : this.semanticElements) {
            Iterators.addAll((Collection)result, (Iterator)sem.eAllContents());
        }
        return result;
    }
}

