/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import java.util.List;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.ui.forms.swt.TablePropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.PopUpListFieldStyle;
import org.eclipse.sapphire.ui.forms.swt.internal.PossibleValue;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public final class PopUpListFieldCellEditorPresentation
extends ComboBoxCellEditor {
    private final StructuredViewer viewer;
    private final TablePropertyEditorPresentation.SelectionProvider selectionProvider;
    private final Property property;
    private List<PossibleValue> possibleValues;
    private boolean isDefaultValue;
    private CCombo combo;
    private boolean disableFocusLostHandler;
    private ISelection selectionPriorToActivation;

    public PopUpListFieldCellEditorPresentation(StructuredViewer parent, TablePropertyEditorPresentation.SelectionProvider selectionProvider, Property property, PopUpListFieldStyle popUpListFieldStyle, int style) {
        this.viewer = parent;
        this.selectionProvider = selectionProvider;
        this.property = property;
        this.setStyle(style | (popUpListFieldStyle == PopUpListFieldStyle.STRICT ? 8 : 0));
        this.create((Composite)parent.getControl());
        this.combo = (CCombo)this.getControl();
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PopUpListFieldCellEditorPresentation.this.isDefaultValue = false;
            }
        });
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PopUpListFieldCellEditorPresentation.this.isDefaultValue = false;
            }
        });
        this.possibleValues = PossibleValue.factory(property).entries();
        String[] contentForCombo = new String[this.possibleValues.size()];
        int i = 0;
        int n = this.possibleValues.size();
        while (i < n) {
            contentForCombo[i] = this.possibleValues.get(i).label();
            ++i;
        }
        this.setItems(contentForCombo);
    }

    protected Object doGetValue() {
        if (this.isDefaultValue) {
            return null;
        }
        int index = this.combo.getSelectionIndex();
        if (index == -1) {
            ValueNormalizationService valueNormalizationService = (ValueNormalizationService)this.property.service(ValueNormalizationService.class);
            String value = valueNormalizationService.normalize(this.combo.getText());
            if (value.length() > 0) {
                return value;
            }
            return null;
        }
        return this.possibleValues.get(index).value();
    }

    protected void doSetValue(Object value) {
        Value val = (Value)value;
        ValueNormalizationService valueNormalizationService = (ValueNormalizationService)this.property.service(ValueNormalizationService.class);
        String text = valueNormalizationService.normalize(val.text());
        int index = -1;
        int i = 0;
        int n = this.possibleValues.size();
        while (index == -1 && i < n) {
            if (this.possibleValues.get(i).value().equals(text)) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            if (text != null) {
                this.combo.setText(text);
            }
        } else {
            this.combo.select(index);
        }
        this.isDefaultValue = val.text(false) == null && val.getDefaultContent() != null;
    }

    public void activate() {
        this.selectionPriorToActivation = this.viewer.getSelection();
        if (this.selectionProvider != null) {
            this.selectionProvider.setFakeSelection(this.selectionPriorToActivation);
        }
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        super.activate();
    }

    protected void focusLost() {
        if (!this.disableFocusLostHandler) {
            this.disableFocusLostHandler = true;
            super.focusLost();
            this.disableFocusLostHandler = false;
            this.viewer.setSelection(this.selectionPriorToActivation);
            if (this.selectionProvider != null) {
                this.selectionProvider.setFakeSelection(null);
            }
            this.selectionPriorToActivation = null;
        }
    }
}

