/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.utils;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.utils.ZoomingInsetsHandleLocator;

public class SapphireSurroundingHandle
extends AbstractHandle {
    private int lineWidth = 1;
    private int lineOffset = 0;
    private int lineStyle = 2;
    private org.eclipse.swt.graphics.Color lineColor;
    private DiagramResourceCache resourceCache;
    private DiagramConfigurationManager configManager;
    private boolean movable;

    public SapphireSurroundingHandle(GraphicalEditPart owner, DiagramConfigurationManager configManager, DiagramResourceCache resourceCache, boolean movable) {
        this.resourceCache = resourceCache;
        this.configManager = configManager;
        this.movable = movable;
        this.setOwner(owner);
        int lineWidth = this.getLineWidth();
        this.setLocator(new ZoomingInsetsHandleLocator(owner.getFigure(), new Insets(lineWidth, lineWidth, lineWidth, lineWidth)));
        this.setOpaque(false);
        this.lineColor = this.resourceCache.getOutlineColor();
        if (movable) {
            this.setCursor(Cursors.SIZEALL);
        } else {
            this.setCursor(null);
        }
    }

    protected DragTracker createDragTracker() {
        if (this.movable) {
            DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this.getOwner());
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
        return null;
    }

    public boolean containsPoint(int x, int y) {
        if (!this.getBounds().contains(x, y)) {
            return false;
        }
        Rectangle inner = FigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, 2 * this.getLineWidth());
        return !inner.contains(x, y);
    }

    public Point getAccessibleLocation() {
        Point p = this.getBounds().getTopRight().translate(-1, this.getBounds().height / 4);
        this.translateToAbsolute((Translatable)p);
        return p;
    }

    public void paintFigure(Graphics g) {
        g.setAntialias(1);
        g.setLineWidth(this.getLineWidth());
        Rectangle r = new Rectangle(this.getBounds());
        int zoom = this.configManager.getDiagramEditor().getPart().getZoomLevel();
        int scaledInset = -this.getLineOffset() * zoom / 100;
        r.shrink(scaledInset, scaledInset);
        r = FigureUtil.getAdjustedRectangle(r, 1.0, this.getLineWidth());
        this.prepareForDrawing(g, 1);
        g.drawLine(r.getTopLeft(), r.getTopRight());
        this.prepareForDrawing(g, 4);
        g.drawLine(r.getBottomLeft(), r.getBottomRight());
        this.prepareForDrawing(g, 16);
        g.drawLine(r.getTopRight(), r.getBottomRight());
        this.prepareForDrawing(g, 8);
        g.drawLine(r.getTopLeft(), r.getBottomLeft());
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public void setLineOffset(int lineOffset) {
        this.lineOffset = lineOffset;
    }

    public void setLineStyle(int style) {
        this.lineStyle = style;
    }

    public void setLineColor(Color color) {
        this.lineColor = this.resourceCache.getColor(color);
    }

    private void prepareForDrawing(Graphics g, int direction) {
        g.setLineStyle(this.lineStyle);
        this.setForegroundColor(this.lineColor);
        g.setForegroundColor(this.getForegroundColor());
    }
}

