/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.VerticalAlignment;
import org.eclipse.sapphire.ui.diagram.shape.def.LayoutConstraintDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutConstraintDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutOrientation;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeLayoutDef;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.layout.SapphireSequenceLayoutConstraint;
import org.eclipse.sapphire.ui.swt.gef.layout.SapphireStackLayoutConstraint;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.ContainerShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ShapeUtil {
    public static boolean updateFigureForShape(ShapePresentation updateShape, DiagramResourceCache resourceCache, DiagramConfigurationManager configManager) {
        if (updateShape == null || updateShape instanceof ContainerShapePresentation) {
            return false;
        }
        IFigure updateFigure = updateShape.getFigure();
        IFigure containerFigure = updateShape.getParentFigure();
        if (updateShape.visible()) {
            ContainerShapePresentation containerPresentation = (ContainerShapePresentation)updateShape.parent();
            if (containerFigure != null) {
                int index = containerPresentation.getChildFigureIndex(updateShape);
                if (updateFigure != null) {
                    containerFigure.remove(updateFigure);
                }
                updateShape.render();
                updateFigure = updateShape.getFigure();
                if (updateFigure != null) {
                    Object layoutConstraint = ShapeUtil.getLayoutConstraint(updateShape, containerPresentation.getLayout());
                    if (layoutConstraint != null) {
                        containerFigure.add(updateFigure, layoutConstraint, index);
                    } else {
                        containerFigure.add(updateFigure, index);
                    }
                }
                containerFigure.revalidate();
            }
        } else if (!updateShape.visible() && updateFigure != null) {
            updateShape.removeFigure();
            containerFigure.remove(updateFigure);
            containerFigure.revalidate();
        }
        return true;
    }

    public static Object getLayoutConstraint(ShapePresentation childShapePresentation, ShapeLayoutDef layoutDef) {
        Object layoutConstraint = null;
        if (layoutDef instanceof SequenceLayoutDef) {
            if (((SequenceLayoutDef)layoutDef).getOrientation().content() != SequenceLayoutOrientation.STACKED) {
                SequenceLayoutConstraintDef def = (SequenceLayoutConstraintDef)childShapePresentation.getLayoutConstraint();
                layoutConstraint = new SapphireSequenceLayoutConstraint(def);
            } else {
                SequenceLayoutConstraintDef constraintDef;
                SapphireStackLayoutConstraint constraint = null;
                if (childShapePresentation.getLayoutConstraint() != null && (constraintDef = (SequenceLayoutConstraintDef)childShapePresentation.getLayoutConstraint()) != null) {
                    constraint = new SapphireStackLayoutConstraint((HorizontalAlignment)constraintDef.getHorizontalAlignment().content(), (VerticalAlignment)constraintDef.getVerticalAlignment().content(), (Integer)constraintDef.getMarginTop().content(), (Integer)constraintDef.getMarginBottom().content(), (Integer)constraintDef.getMarginLeft().content(), (Integer)constraintDef.getMarginRight().content());
                }
                layoutConstraint = constraint != null ? constraint : new SapphireStackLayoutConstraint();
            }
        }
        return layoutConstraint;
    }

    public static int getTextAlignment(LayoutConstraintDef constraint) {
        int alignment = 2;
        HorizontalAlignment sapphireAlign = (HorizontalAlignment)constraint.getHorizontalAlignment().content();
        switch (sapphireAlign) {
            case LEFT: {
                alignment = 1;
                break;
            }
            case RIGHT: {
                alignment = 4;
                break;
            }
        }
        return alignment;
    }

    public static int getPresentationCount(ContainerShapePresentation parentPresentation, ShapePresentation shapePresentation) {
        int count = 0;
        for (ShapePresentation sp : parentPresentation.getChildren()) {
            if (((Object)((Object)shapePresentation)).equals((Object)sp)) {
                return count;
            }
            if (sp instanceof ContainerShapePresentation) continue;
            ++count;
        }
        return count;
    }
}

