/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;

public class SapphireMidpointLocator
extends ConnectionLocator {
    private Point delta = null;
    private DiagramConfigurationManager manager;

    public SapphireMidpointLocator(DiagramConfigurationManager manager, Connection connection) {
        super(connection);
        this.manager = manager;
    }

    public SapphireMidpointLocator(DiagramConfigurationManager manager, Connection connection, int deltaX, int deltaY) {
        super(connection);
        this.manager = manager;
        this.delta = new Point(deltaX, deltaY);
    }

    public Point getMidpoint() {
        Point p = this.getLocation(this.getConnection().getPoints());
        this.getConnection().translateToAbsolute((Translatable)p);
        return p;
    }

    protected Rectangle getNewBounds(Dimension size, Point center) {
        return new Rectangle(center, size);
    }

    protected Point getReferencePoint() {
        Point midPoint = super.getReferencePoint();
        if (this.delta != null) {
            Point realDelta = new Point(this.delta.x, this.delta.y);
            double zoom = this.manager.getDiagramEditor().getZoomLevel();
            realDelta = realDelta.getScaled(zoom);
            midPoint.x += realDelta.x;
            midPoint.y += realDelta.y;
        } else {
            Connection conn = this.getConnection();
            PointList points = conn.getPoints();
            int size = points.size();
            if (size % 2 == 0) {
                int i = points.size() / 2;
                int j = i - 1;
                Point p1 = points.getPoint(j);
                Point p2 = points.getPoint(i);
                double value = Math.atan2(p1.y - p2.y, p1.x - p2.x);
                double angle = Math.toDegrees(value);
                if (angle > 0.0 && angle < 90.0 || angle > -180.0 && angle < -90.0) {
                    midPoint.y -= 12;
                }
            } else {
                int index = size / 2;
                Point p1 = points.getPoint(index - 1);
                Point p2 = points.getPoint(index + 1);
                if (p1.x > midPoint.x && p2.x > midPoint.x) {
                    midPoint.x += 8;
                }
                if (p1.y > midPoint.y && p2.y > midPoint.y) {
                    midPoint.y += 8;
                }
            }
        }
        return midPoint;
    }
}

