/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModelBase;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramConnectionPresentation;

public class DiagramConnectionModel
extends DiagramModelBase {
    public static final String CONNECTION_UPDATES = "CONNECTION_UPDATES";
    public static final String CONNECTION_LABEL_MOVED = "CONNECTION_LABEL_MOVED";
    public static final String CONNECTION_BEND_POINTS = "CONNECTION_BEND_POINTS";
    public static final String CONNECTION_START_EDITING = "CONNECTION_START_EDITING";
    private DiagramModel parent;
    private DiagramConnectionPresentation connPresentation;
    private DiagramNodeModel sourceNode;
    private DiagramNodeModel targetNode;

    public DiagramConnectionModel(DiagramModel parent, DiagramConnectionPresentation connPresentation) {
        this.parent = parent;
        this.connPresentation = connPresentation;
        connPresentation.init(this);
    }

    public DiagramModel getDiagramModel() {
        return this.parent;
    }

    @Override
    public SapphirePart getSapphirePart() {
        return this.getModelPart();
    }

    public DiagramConnectionPresentation getPresentation() {
        return this.connPresentation;
    }

    public DiagramConnectionPart getModelPart() {
        return this.getPresentation().part();
    }

    public DiagramNodeModel getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(DiagramNodeModel sourceNode) {
        this.sourceNode = sourceNode;
    }

    public DiagramNodeModel getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(DiagramNodeModel targetNode) {
        this.targetNode = targetNode;
    }

    public void handleUpdateConnection() {
        this.firePropertyChange(CONNECTION_UPDATES, null, this.getModelPart().getLabel());
    }

    public void handleUpdateConnectionMoveLabel() {
        this.firePropertyChange(CONNECTION_LABEL_MOVED, null, this.getModelPart());
    }

    public void handleUpdateBendPoints() {
        this.firePropertyChange(CONNECTION_BEND_POINTS, null, this.getModelPart());
    }

    public void handleStartEditing() {
        this.firePropertyChange(CONNECTION_START_EDITING, null, null);
    }
}

