/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.condition;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.AndMatcher;
import org.eclipse.reddeer.common.matcher.MatcherBuilder;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.util.InstanceValidator;
import org.eclipse.reddeer.jface.api.Window;
import org.eclipse.reddeer.jface.matcher.WindowMatcher;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;

public class WindowIsAvailable
extends AbstractWaitCondition {
    private Logger logger = Logger.getLogger(WindowIsAvailable.class);
    private AndMatcher matcher;
    private Shell foundShell;
    private Window window;

    public WindowIsAvailable(Window window) {
        InstanceValidator.checkNotNull((Object)window, (String)"window");
        InstanceValidator.checkNotNull((Object)window.getShell(), (String)"window shell");
        this.window = window;
    }

    public WindowIsAvailable(String windowTitle) {
        this(new Matcher[]{new WithTextMatcher(windowTitle)});
    }

    public WindowIsAvailable(Matcher<?> ... matchers) {
        this(org.eclipse.jface.window.Window.class, matchers);
    }

    public <T extends org.eclipse.jface.window.Window> WindowIsAvailable(Class<T> windowClass, Matcher<?> ... matchers) {
        WindowMatcher wm = new WindowMatcher(windowClass);
        Matcher[] allMatchers = MatcherBuilder.getInstance().addMatcher(matchers, (Matcher)wm);
        this.matcher = new AndMatcher(allMatchers);
    }

    public boolean test() {
        if (this.window != null) {
            Shell[] shellArray = ShellLookup.getInstance().getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell s = shellArray[n2];
                if (((Shell)this.window.getShell().getSWTWidget()).equals(s)) {
                    return true;
                }
                ++n2;
            }
        } else {
            Shell[] availableShells;
            this.logger.debug("Looking for Window matching " + this.matcher);
            Shell[] shellArray = availableShells = ShellLookup.getInstance().getShells();
            int n = availableShells.length;
            int n3 = 0;
            while (n3 < n) {
                Shell shell = shellArray[n3];
                if (this.matcher.matches((Object)shell)) {
                    this.foundShell = shell;
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public Shell getResult() {
        return this.foundShell;
    }

    public String description() {
        if (this.window != null) {
            return "window is available";
        }
        return "window matching " + this.matcher + " is available.";
    }
}

