/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ConnectivityChecker;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.LoadingRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ScheduleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.LateConsumerMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.DatumConnection;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;

public class QVTs2QVTs
extends QVTimperativeHelper {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull String rootName;
    private final @NonNull LoadingRegionAnalysis loadingRegionAnalysis;
    protected final @NonNull CompleteModel completeModel;
    private final @NonNull Map<@NonNull Region, RegionAnalysis> region2regionAnalysis = new HashMap<Region, RegionAnalysis>();
    private final @NonNull Map<@NonNull Model, DomainUsage> inputModels = new HashMap<Model, DomainUsage>();
    private final @NonNull StandardLibraryHelper standardLibraryHelper;
    public final @NonNull Map<@NonNull ClassDatum, @NonNull Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection>> classDatum2nodes2nodeConnections = new HashMap<ClassDatum, Map<Set<Node>, NodeConnection>>();
    public final @NonNull Map<@NonNull Set<@NonNull NavigableEdge>, @NonNull EdgeConnection> edges2edgeConnection = new HashMap<Set<NavigableEdge>, EdgeConnection>();
    private @Nullable ContentsAnalysis<@NonNull MappingRegion> partitionedContentsAnalysis;

    public QVTs2QVTs(@NonNull ProblemHandler problemHandler, @NonNull ScheduleManager qvtm2qvts, @NonNull String rootName) {
        super(qvtm2qvts.getEnvironmentFactory());
        this.scheduleManager = qvtm2qvts;
        this.standardLibraryHelper = new StandardLibraryHelper(this.standardLibrary);
        this.problemHandler = problemHandler;
        this.rootName = rootName;
        this.loadingRegionAnalysis = new LoadingRegionAnalysis(this.scheduleManager, this.createLoadingRegion());
        this.completeModel = this.environmentFactory.getCompleteModel();
    }

    private void computeInputModels() {
        for (ClassDatum classDatum : this.scheduleManager.getClassDatums()) {
            Model model;
            Class type;
            Package asPackage;
            DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)classDatum);
            if (!domainUsage.isInput() || domainUsage.isOutput() || (asPackage = PivotUtil.getContainingPackage((EObject)(type = classDatum.getCompleteClass().getPrimaryClass()))) == null || "http://www.eclipse.org/ocl/2015/Orphanage".equals(asPackage.getURI()) || (model = PivotUtil.getContainingModel((EObject)type)) == null) continue;
            this.inputModels.put(model, domainUsage);
        }
    }

    private @NonNull NodeConnection createNodeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Set<@NonNull Node> sourceSet, @NonNull ClassDatum classDatum, @NonNull SymbolNameBuilder s) {
        NodeConnection connection = QVTscheduleFactory.eINSTANCE.createNodeConnection();
        connection.setOwningScheduledRegion(scheduledRegion);
        connection.getSourceEnds().addAll(sourceSet);
        connection.setName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)connection));
        connection.setClassDatum(classDatum);
        for (Node sourceNode : sourceSet) {
            sourceNode.addOutgoingConnection(connection);
        }
        return connection;
    }

    private @NonNull LoadingRegion createRootContainmentRegion(@NonNull RootPartition rootPartition) {
        ScheduledRegion rootScheduledRegion = rootPartition.getScheduledRegion();
        LoadingRegion loadingRegion = (LoadingRegion)this.loadingRegionAnalysis.getRegion();
        loadingRegion.setOwningScheduledRegion(rootScheduledRegion);
        this.scheduleManager.writeDebugGraphs((Graphable)loadingRegion, null);
        return loadingRegion;
    }

    private void createConnections(@NonNull RootPartition rootPartition) {
        ScheduledRegion rootScheduledRegion = rootPartition.getScheduledRegion();
        ArrayList<@NonNull E> sortedCallableRegions = new ArrayList();
        Iterables.addAll(sortedCallableRegions, (Iterable)rootScheduledRegion.getCallableRegions());
        Collections.sort(sortedCallableRegions, NameUtil.NAMEABLE_COMPARATOR);
        for (Region region : sortedCallableRegions) {
            this.createIncomingConnections(region);
        }
        this.scheduleManager.writeDebugGraphs("4-bindings", true, true, false);
    }

    private void createEdgeConnection(@NonNull Region region, @NonNull Node castTargetNode, @NonNull Iterable<@NonNull NavigableEdge> predicatedEdges) {
        ScheduledRegion invokingRegion2 = region.getContainingScheduledRegion();
        assert (invokingRegion2 != null);
        Node castTarget = castTargetNode;
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)castTarget);
        ArrayList<Node> attributeConnectionSourceNodes = null;
        ArrayList<@NonNull String> partialNames = new ArrayList<String>();
        for (NavigableEdge predicatedEdge : predicatedEdges) {
            assert (predicatedEdge.isNavigation());
            assert (predicatedEdge.getIncomingConnection() == null);
            assert (!predicatedEdge.isCast());
            Property predicatedProperty = predicatedEdge.getProperty();
            assert (!predicatedProperty.isIsImplicit());
            NavigableEdge castEdge = QVTscheduleUtil.getCastTarget((NavigableEdge)predicatedEdge);
            if (classDatum.getCompleteClass().getPrimaryClass() instanceof DataType) {
                Iterable<@NonNull NavigableEdge> realizedEdges = this.getNewEdges(predicatedEdge, classDatum);
                if (realizedEdges == null) continue;
                if (attributeConnectionSourceNodes == null) {
                    attributeConnectionSourceNodes = new ArrayList<Node>();
                }
                for (NavigableEdge realizedEdge : realizedEdges) {
                    if (!this.scheduleManager.isElementallyConformantSource(realizedEdge, predicatedEdge) || !QVTscheduleUtil.isConformantTarget((NavigableEdge)realizedEdge, (NavigableEdge)predicatedEdge)) continue;
                    attributeConnectionSourceNodes.add(realizedEdge.getEdgeTarget());
                }
                partialNames.add(QVTscheduleUtil.getName((Nameable)predicatedEdge.getEdgeSource().getCompleteClass()));
                partialNames.add(QVTscheduleUtil.getName((Nameable)predicatedProperty));
                continue;
            }
            Iterable<@NonNull Node> sourceNodes = this.getNewNodes(classDatum);
            Iterable<@NonNull NavigableEdge> realizedEdges = this.getNewEdges(predicatedEdge, classDatum);
            if (realizedEdges != null) {
                HashSet<@NonNull Region> edgeSourceRegions = new HashSet<Region>();
                HashSet<@NonNull Region> nodeSourceRegions = new HashSet<Region>();
                for (NavigableEdge realizedEdge : realizedEdges) {
                    edgeSourceRegions.add(QVTscheduleUtil.getOwningRegion((ConnectionEnd)realizedEdge));
                }
                if (sourceNodes != null) {
                    for (Node sourceNode : sourceNodes) {
                        nodeSourceRegions.add(QVTscheduleUtil.getOwningRegion((Node)sourceNode));
                    }
                }
                if (!nodeSourceRegions.containsAll(edgeSourceRegions)) {
                    HashSet<Region> conformantEdgeSourceRegions = null;
                    ArrayList<NavigableEdge> thoseEdges = null;
                    for (NavigableEdge realizedEdge : realizedEdges) {
                        if (!this.scheduleManager.isElementallyConformantSource(realizedEdge, predicatedEdge) || !QVTscheduleUtil.isConformantTarget((NavigableEdge)realizedEdge, (NavigableEdge)predicatedEdge)) continue;
                        if (thoseEdges == null) {
                            thoseEdges = new ArrayList<NavigableEdge>();
                            conformantEdgeSourceRegions = new HashSet<Region>();
                        }
                        if (thoseEdges.contains(realizedEdge)) continue;
                        thoseEdges.add(realizedEdge);
                        assert (conformantEdgeSourceRegions != null);
                        conformantEdgeSourceRegions.add(QVTscheduleUtil.getOwningRegion((ConnectionEnd)realizedEdge));
                    }
                    if (thoseEdges != null && !nodeSourceRegions.containsAll(conformantEdgeSourceRegions)) {
                        EdgeConnection edgeConnection = this.getEdgeConnection(invokingRegion2, thoseEdges, predicatedProperty);
                        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
                            QVTscheduleConstants.CONNECTION_CREATION.println("  EdgeConnection \"" + edgeConnection + "\" to " + predicatedEdge);
                        }
                        if (!Iterables.contains((Iterable)edgeConnection.getTargetEdges(), (Object)castEdge)) {
                            edgeConnection.addUsedTargetEdge(castEdge, false);
                            if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
                                for (NavigableEdge thatEdge : thoseEdges) {
                                    QVTscheduleConstants.CONNECTION_CREATION.println("    from " + thatEdge.getOwningRegion() + "  : " + thatEdge);
                                }
                            }
                        }
                    }
                }
            }
            if (sourceNodes == null || castTarget.isLoaded() || castTarget.isConstant() || castTarget.isHead() || castTarget.isOperation() || castTarget.getIncomingConnection() != null) continue;
            NodeConnection predicatedConnection = this.getNodeConnection(invokingRegion2, sourceNodes, classDatum, this.scheduleManager.getDomainUsage((Element)classDatum));
            predicatedConnection.addUsedTargetNode(castTarget, false);
            if (!QVTscheduleConstants.CONNECTION_CREATION.isActive()) continue;
            QVTscheduleConstants.CONNECTION_CREATION.println("  NodeConnection \"" + predicatedConnection + "\" to " + castTarget);
            for (Node sourceNode : sourceNodes) {
                QVTscheduleConstants.CONNECTION_CREATION.println("    from " + sourceNode.getOwningRegion() + " : " + sourceNode);
            }
        }
        if (attributeConnectionSourceNodes != null) {
            NodeConnection nodeConnection = this.getAttributeConnection(invokingRegion2, attributeConnectionSourceNodes, partialNames, classDatum);
            nodeConnection.addUsedTargetNode(castTarget, false);
            if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
                QVTscheduleConstants.CONNECTION_CREATION.println("  Attribute NodeConnection \"" + nodeConnection + "\" to " + castTarget);
            }
        }
    }

    private @NonNull EdgeConnection createEdgeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Set<@NonNull NavigableEdge> sourceSet, @NonNull Property property, @NonNull SymbolNameBuilder s) {
        assert (!property.isIsImplicit());
        EdgeConnection connection = QVTscheduleFactory.eINSTANCE.createEdgeConnection();
        connection.setOwningScheduledRegion(scheduledRegion);
        connection.setName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)connection));
        connection.getSourceEnds().addAll(sourceSet);
        connection.setReferredProperty(property);
        for (NavigableEdge sourceEdge : sourceSet) {
            sourceEdge.addOutgoingConnection(connection);
        }
        return connection;
    }

    private @Nullable NodeConnection createHeadConnection(@NonNull Region region, @NonNull Node headNode) {
        ScheduledRegion invokingRegion2 = QVTscheduleUtil.getContainingScheduledRegion((Region)region);
        ArrayList<Node> headSources = null;
        boolean isSpeculation = false;
        Iterable<@NonNull Node> sourceNodes = this.getIntroducingOrNewNodes(headNode);
        if (!this.scheduleManager.useActivators() && sourceNodes != null) {
            for (Node sourceNode : sourceNodes) {
                if (!sourceNode.isSpeculation()) continue;
                isSpeculation = true;
            }
        }
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)headNode);
        if (isSpeculation && !headNode.isSpeculated()) {
            sourceNodes = this.getPartitionedContentsAnalysis().getOldNodes(classDatum);
            assert (sourceNodes != null);
        }
        if (sourceNodes != null) {
            for (Node sourceNode : sourceNodes) {
                HashMap<Node, Node> called2calling;
                boolean isSource = true;
                if (!(!isSpeculation || headNode.isSpeculated() || sourceNode.isSpeculated() && sourceNode.isHead())) {
                    isSource = false;
                }
                if (!isSource || !this.isCompatiblePattern(region, headNode, sourceNode, called2calling = new HashMap<Node, Node>())) continue;
                if (headSources == null) {
                    headSources = new ArrayList<Node>();
                }
                headSources.add(sourceNode);
            }
        }
        if (headSources == null) {
            return null;
        }
        NodeConnection headConnection = this.getNodeConnection(invokingRegion2, headSources, classDatum, this.scheduleManager.getDomainUsage((Element)classDatum));
        if (headNode.isDependency()) {
            headConnection.addUsedTargetNode(headNode, false);
        } else {
            headConnection.addPassedTargetNode(headNode);
        }
        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
            QVTscheduleConstants.CONNECTION_CREATION.println(String.valueOf(headNode.isDependency() ? "  Extra NodeConnection " : "  Head NodeConnection \"") + headConnection + "\" to " + headNode);
            for (Node sourceNode : headSources) {
                QVTscheduleConstants.CONNECTION_CREATION.println("    from " + sourceNode.getOwningRegion() + " : " + sourceNode);
            }
        }
        return headConnection;
    }

    private @Nullable Iterable<@NonNull NodeConnection> createHeadConnections(@NonNull Region region) {
        ArrayList<@NonNull NodeConnection> headConnections = null;
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Region)region)) {
            if (headNode.isDependency()) {
                this.createHeadConnection(region, headNode);
                continue;
            }
            NodeConnection headConnection = this.createHeadConnection(region, headNode);
            if (headConnection == null) {
                this.scheduleManager.addRegionWarning(region, "No incoming connections for " + headNode.getName(), new Object[0]);
                headConnection = this.createHeadConnection(region, headNode);
                return null;
            }
            if (headConnections == null) {
                headConnections = new ArrayList<NodeConnection>();
            }
            headConnections.add(headConnection);
        }
        return headConnections;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createIncomingConnections(@NonNull Region region) {
        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
            QVTscheduleConstants.CONNECTION_CREATION.println("connecting " + region);
        }
        assert (!(this instanceof LoadingRegion));
        Iterable<@NonNull NodeConnection> headConnections = this.createHeadConnections(region);
        if (headConnections != null) {
            HashMap<@NonNull Node, @NonNull ArrayList<@NonNull NavigationEdge>> castTargetNode2predicatedEdges = new HashMap<Node, ArrayList<NavigationEdge>>();
            for (NavigationEdge predicatedEdge : region.getPredicatedNavigationEdges()) {
                assert (!predicatedEdge.isCast());
                assert (predicatedEdge.isNavigation());
                assert (predicatedEdge.getIncomingConnection() == null);
                Property predicatedProperty = predicatedEdge.getReferredProperty();
                if (predicatedProperty.isIsImplicit()) continue;
                NavigableEdge castEdge = QVTscheduleUtil.getCastTarget((NavigableEdge)predicatedEdge);
                Node castTargetNode = QVTscheduleUtil.getCastTarget((Node)castEdge.getEdgeTarget());
                ArrayList<@NonNull NavigationEdge> predicatedEdges = (ArrayList<NavigationEdge>)castTargetNode2predicatedEdges.get(castTargetNode);
                if (predicatedEdges == null) {
                    predicatedEdges = new ArrayList<NavigationEdge>();
                    castTargetNode2predicatedEdges.put(castTargetNode, predicatedEdges);
                }
                predicatedEdges.add(predicatedEdge);
            }
            for (Node castTargetNode : castTargetNode2predicatedEdges.keySet()) {
                @NonNull List predicatedEdges = (List)castTargetNode2predicatedEdges.get(castTargetNode);
                assert (predicatedEdges != null);
                this.createEdgeConnection(region, castTargetNode, predicatedEdges);
            }
        }
    }

    protected @NonNull LoadingRegion createLoadingRegion() {
        LoadingRegion loadingRegion = QVTscheduleFactory.eINSTANCE.createLoadingRegion();
        loadingRegion.setName("__root__");
        SymbolNameBuilder s = new SymbolNameBuilder();
        s.appendString("__root__");
        loadingRegion.setSymbolName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)loadingRegion));
        return loadingRegion;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createLocalSchedule2(@NonNull RootPartition rootPartition, @NonNull List<@NonNull Collection<@NonNull Region>> parallelSchedule) {
        HashMap<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges = new HashMap<TypedModel, Map<Property, List<NavigableEdge>>>();
        HashMap<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges = new HashMap<TypedModel, Map<Property, List<NavigableEdge>>>();
        for (Iterable iterable : parallelSchedule) {
            for (Region region : iterable) {
                QVTscheduleConstants.POLLED_PROPERTIES.println("building indexes for " + region + " " + region.getIndexRangeText());
                RegionAnalysis regionAnalysis = this.scheduleManager.getRegionAnalysis(region);
                regionAnalysis.buildNavigationEdgesIndex(typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
            }
        }
        for (Iterable iterable : parallelSchedule) {
            for (Region region : iterable) {
                int earliestIndex = (Integer)region.getIndexes().get(0);
                ArrayList<DatumConnection> redundantConnections = null;
                for (DatumConnection usedConnection : region.getIncomingConnections()) {
                    if (usedConnection.isPassed(region)) continue;
                    boolean isRedundant = true;
                    for (Region sourceRegion : usedConnection.getSourceRegions()) {
                        @NonNull List indexes = sourceRegion.getIndexes();
                        int lastIndex = (Integer)indexes.get(indexes.size() - 1);
                        if (lastIndex < earliestIndex) continue;
                        isRedundant = false;
                        break;
                    }
                    if (!isRedundant) continue;
                    if (redundantConnections == null) {
                        redundantConnections = new ArrayList<DatumConnection>();
                    }
                    redundantConnections.add(usedConnection);
                }
                if (redundantConnections == null) continue;
                for (DatumConnection redundantConnection : redundantConnections) {
                    redundantConnection.removeTargetRegion(region);
                }
            }
        }
        this.scheduleManager.writeDebugGraphs("7-pruned", true, true, false);
        boolean bl = this.scheduleManager.isNoLateConsumerMerge();
        if (!bl) {
            this.lateMerge(rootPartition, parallelSchedule, typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
        }
        for (Iterable iterable : parallelSchedule) {
            for (Region region : iterable) {
                this.getRegionAnalysis(region).computeCheckedOrEnforcedEdges(typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
            }
        }
    }

    public void createSchedule1(@NonNull RootPartition rootPartition) {
        ScheduledRegion rootScheduledRegion = rootPartition.getScheduledRegion();
        this.computeInputModels();
        if (QVTm2QVTs.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.isActive()) {
            QVTm2QVTs.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.println(this.dumpInputModels().reduce("", QVTscheduleUtil.stringJoin((String)"\n\t")));
        }
        this.partitionedContentsAnalysis = new ContentsAnalysis<MappingRegion>(this.scheduleManager);
        ContentsAnalysis<@NonNull MappingRegion> contentsAnalysis2 = this.partitionedContentsAnalysis;
        for (MappingRegion region : QVTscheduleUtil.getMappingRegions((ScheduledRegion)rootScheduledRegion)) {
            contentsAnalysis2.addRegion(region);
        }
        if (QVTm2QVTs.DUMP_CLASS_TO_REALIZED_NODES.isActive()) {
            QVTm2QVTs.DUMP_CLASS_TO_REALIZED_NODES.println(contentsAnalysis2.dumpClass2newNode());
        }
        if (QVTm2QVTs.DUMP_CLASS_TO_CONSUMING_NODES.isActive()) {
            QVTm2QVTs.DUMP_CLASS_TO_CONSUMING_NODES.println(contentsAnalysis2.dumpClass2oldNode());
        }
        this.createRootContainmentRegion(rootPartition);
        this.createConnections(rootPartition);
    }

    protected void createSchedule2(@NonNull RootPartition rootPartition) {
        ArrayList<@NonNull RootPartition> allRootPartitions = new ArrayList<RootPartition>();
        allRootPartitions.add(rootPartition);
        ScheduleAnalysis scheduleAnalysis = new ScheduleAnalysis(this.scheduleManager, rootPartition);
        scheduleAnalysis.schedule(rootPartition);
        for (RootPartition aRootPartition : allRootPartitions) {
            List<@NonNull Collection<@NonNull Region>> newRegionSchedule = aRootPartition.getRegionSchedule();
            this.createLocalSchedule2(aRootPartition, newRegionSchedule);
        }
    }

    private Stream<String> dumpInputModels() {
        Stream<String> entries = this.inputModels.keySet().stream().map(k -> String.valueOf(String.valueOf(k)) + " : " + String.valueOf(this.inputModels.get(k)));
        return entries.sorted();
    }

    public @NonNull NodeConnection getAttributeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Iterable<@NonNull Node> sourceNodes, @NonNull List<@NonNull String> partialNames, @NonNull ClassDatum classDatum) {
        HashSet sourceSet;
        NodeConnection connection;
        Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection> nodes2connection = this.classDatum2nodes2nodeConnections.get(classDatum);
        if (nodes2connection == null) {
            nodes2connection = new HashMap<Set<Node>, NodeConnection>();
            this.classDatum2nodes2nodeConnections.put(classDatum, nodes2connection);
        }
        if ((connection = nodes2connection.get(sourceSet = Sets.newHashSet(sourceNodes))) == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("ja");
            for (String partialName : partialNames) {
                s.appendString("_");
                s.appendName(partialName);
            }
            connection = this.createNodeConnection(scheduledRegion, sourceSet, classDatum, s);
            nodes2connection.put(sourceSet, connection);
        }
        return connection;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull EdgeConnection getEdgeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Iterable<@NonNull NavigableEdge> sourceEdges, @NonNull Property property) {
        @NonNull HashSet sourceSet = Sets.newHashSet(sourceEdges);
        EdgeConnection connection = this.edges2edgeConnection.get(sourceSet);
        if (connection == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("je_");
            s.appendName(property.getOwningClass().getName());
            s.appendString("_");
            s.appendName(property.getName());
            connection = this.createEdgeConnection(scheduledRegion, sourceSet, property, s);
            this.edges2edgeConnection.put(sourceSet, connection);
        }
        return connection;
    }

    public @Nullable Iterable<@NonNull Node> getIntroducingOrNewNodes(@NonNull Node headNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)headNode);
        ContentsAnalysis<@NonNull MappingRegion> partitionedContentsAnalysis = this.getPartitionedContentsAnalysis();
        if (!this.scheduleManager.getDomainUsage((Element)classDatum).isInput()) {
            return partitionedContentsAnalysis.getNewNodes(classDatum);
        }
        ArrayList<@NonNull Node> nodes = new ArrayList<Node>();
        nodes.add(this.loadingRegionAnalysis.getIntroducerNode(headNode));
        for (TypedModel dependsOn : QVTbaseUtil.getDependsOns((TypedModel)QVTscheduleUtil.getTypedModel((ClassDatum)classDatum))) {
            ClassDatum classDatum2 = this.scheduleManager.getClassDatum(dependsOn, headNode.getCompleteClass().getPrimaryClass());
            Iterable<@NonNull Node> newNodes = partitionedContentsAnalysis.getNewNodes(classDatum2);
            if (newNodes == null) continue;
            for (Node newNode : newNodes) {
                if (nodes.contains(newNode)) continue;
                nodes.add(newNode);
            }
        }
        return nodes;
    }

    public @Nullable Iterable<@NonNull NavigableEdge> getNewEdges(@NonNull NavigableEdge edge, @NonNull ClassDatum requiredClassDatum) {
        return this.getPartitionedContentsAnalysis().getNewEdges(edge, requiredClassDatum);
    }

    public @Nullable Iterable<@NonNull Node> getNewNodes(@NonNull ClassDatum classDatum) {
        return this.getPartitionedContentsAnalysis().getNewNodes(classDatum);
    }

    private @NonNull NodeConnection getNodeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Iterable<@NonNull Node> sourceNodes, @NonNull ClassDatum classDatum, @NonNull DomainUsage domainUsage) {
        HashSet sourceSet;
        NodeConnection connection;
        Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection> nodes2connection = this.classDatum2nodes2nodeConnections.get(classDatum);
        if (nodes2connection == null) {
            nodes2connection = new HashMap<Set<Node>, NodeConnection>();
            this.classDatum2nodes2nodeConnections.put(classDatum, nodes2connection);
        }
        if ((connection = nodes2connection.get(sourceSet = Sets.newHashSet(sourceNodes))) == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("j");
            s.appendString(domainUsage.isInput() ? "i" : (domainUsage.isOutput() ? "o" : "m"));
            s.appendString("_");
            s.appendName(classDatum.getCompleteClass().getName());
            connection = this.createNodeConnection(scheduledRegion, sourceSet, classDatum, s);
            nodes2connection.put(sourceSet, connection);
        }
        return connection;
    }

    public @NonNull ContentsAnalysis<@NonNull MappingRegion> getPartitionedContentsAnalysis() {
        return (ContentsAnalysis)ClassUtil.nonNullState(this.partitionedContentsAnalysis);
    }

    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        RegionAnalysis regionAnalysis = this.region2regionAnalysis.get(region);
        if (regionAnalysis == null) {
            regionAnalysis = this.scheduleManager.getRegionAnalysis(region);
            this.region2regionAnalysis.put(region, regionAnalysis);
        }
        return regionAnalysis;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull StandardLibraryHelper getStandardLibraryHelper() {
        return this.standardLibraryHelper;
    }

    private boolean isCompatiblePattern(@NonNull Region region, @NonNull Node calledNode, @NonNull Node callingNode, @NonNull Map<@NonNull Node, @NonNull Node> called2calling) {
        Node oldPrevNode = called2calling.put(calledNode, callingNode);
        if (oldPrevNode != null) {
            return oldPrevNode == callingNode;
        }
        for (NavigableEdge calledEdge : calledNode.getNavigableEdges()) {
            NavigableEdge nextCallingEdge;
            Node nextCalledNode = calledEdge.getEdgeTarget();
            if (nextCalledNode.isRealized() || nextCalledNode.isDataType() || (nextCallingEdge = callingNode.getNavigableEdge(QVTscheduleUtil.getProperty((NavigableEdge)calledEdge))) == null) continue;
            Node nextCallingNode = nextCallingEdge.getEdgeTarget();
            if (nextCallingNode.isNullLiteral() != nextCalledNode.isNullLiteral()) {
                return false;
            }
            if (this.isCompatiblePattern(region, nextCalledNode, nextCallingNode, called2calling)) continue;
            return false;
        }
        return true;
    }

    private void lateMerge(@NonNull RootPartition rootPartition, @NonNull List<@NonNull Collection<@NonNull Region>> parallelSchedule, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges) {
        HashMap<@NonNull Region, @NonNull Integer> region2depth = new HashMap<Region, Integer>();
        int parallelDepth = 0;
        for (Iterable iterable : parallelSchedule) {
            for (Region region : iterable) {
                region2depth.put(region, parallelDepth);
            }
            ++parallelDepth;
        }
        Map<@NonNull MappingRegion, @NonNull List<@NonNull MappingRegion>> map = LateConsumerMerger.merge(this.scheduleManager, rootPartition);
        for (Map.Entry<MappingRegion, List<MappingRegion>> entry : map.entrySet()) {
            MappingRegion newRegion = entry.getKey();
            List<@NonNull MappingRegion> oldRegions = entry.getValue();
            assert (oldRegions.size() >= 2);
            Integer orderedRegionIndex = (Integer)region2depth.get(oldRegions.get(0));
            assert (orderedRegionIndex != null);
            for (MappingRegion oldRegion : oldRegions) {
                Integer depth = (Integer)region2depth.get(oldRegion);
                assert (depth != null);
                parallelSchedule.get(depth).remove(oldRegion);
                this.scheduleManager.setScheduledRegion(oldRegion, null);
            }
            parallelSchedule.get(orderedRegionIndex).add((Region)newRegion);
            QVTscheduleConstants.POLLED_PROPERTIES.println("building indexes for " + newRegion + " " + newRegion.getIndexRangeText());
            RegionAnalysis regionAnalysis = this.scheduleManager.getRegionAnalysis((Region)newRegion);
            regionAnalysis.buildNavigationEdgesIndex(typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull ScheduledRegion> transform(@NonNull ScheduleManager scheduleManager, @NonNull Map<@NonNull ScheduledRegion, Iterable<@NonNull MappingRegion>> scheduledRegion2activeRegions) throws CompilerChainException {
        Set<@NonNull ScheduledRegion> scheduledRegions = scheduledRegion2activeRegions.keySet();
        ArrayList<@NonNull RootPartition> rootPartitions = new ArrayList<RootPartition>();
        for (ScheduledRegion scheduledRegion : scheduledRegions) {
            Transformation transformation = QVTscheduleUtil.getReferredTransformation((ScheduledRegion)scheduledRegion);
            TransformationAnalysis transformationAnalysis = scheduleManager.getTransformationAnalysis(transformation);
            Iterable<@NonNull MappingRegion> activeRegions = scheduledRegion2activeRegions.get(scheduledRegion);
            assert (activeRegions != null);
            RootPartition rootPartition = TransformationPartitioner.partition(transformationAnalysis, this.problemHandler, activeRegions);
            rootPartition.setScheduledRegion(scheduledRegion);
            rootPartitions.add(rootPartition);
        }
        for (RootPartition rootPartition : rootPartitions) {
            ScheduledRegion scheduledRegion = rootPartition.getScheduledRegion();
            @NonNull Iterable mappingRegions = QVTscheduleUtil.getMappingRegions((ScheduledRegion)scheduledRegion);
            assert (Iterables.isEmpty((Iterable)mappingRegions));
            scheduledRegion.setOwnedLoadingRegion((LoadingRegion)this.loadingRegionAnalysis.getRegion());
            List<@NonNull Collection<@NonNull Region>> regionSchedule = rootPartition.getRegionSchedule();
            this.createSchedule1(rootPartition);
            this.createSchedule2(rootPartition);
            ConnectivityChecker.CONNECTIVITY.isActive();
        }
        scheduleManager.writeDebugGraphs("9-final", true, true, true);
        return scheduledRegions;
    }
}

