/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.issue;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.issue.IssueConnector;
import org.eclipse.mylyn.internal.github.ui.issue.IssueRepositoryQueryPage;
import org.eclipse.mylyn.internal.github.ui.issue.IssueRepositorySettingsPage;
import org.eclipse.mylyn.internal.github.ui.issue.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;

public class IssueConnectorUi
extends AbstractRepositoryConnectorUi {
    private final Pattern issuePattern = Pattern.compile("(?:([a-zA-Z0-9_\\.-]+)(?:/([a-zA-Z0-9_\\.-]+))?)?\\#(\\d+)");

    public static IssueConnector getCoreConnector() {
        return (IssueConnector)TasksUi.getRepositoryConnector((String)"github");
    }

    public String getConnectorKind() {
        return "github";
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new IssueRepositorySettingsPage(taskRepository);
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        return new NewTaskWizard(taskRepository, taskSelection);
    }

    public boolean hasSearchPage() {
        return true;
    }

    public IWizard getQueryWizard(TaskRepository taskRepository, IRepositoryQuery queryToEdit) {
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(taskRepository);
        IssueRepositoryQueryPage queryPage = new IssueRepositoryQueryPage(taskRepository, queryToEdit);
        wizard.addPage((IWizardPage)queryPage);
        return wizard;
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int index, int textOffset) {
        ArrayList<Object> hyperlinks = new ArrayList<Object>();
        Matcher matcher = this.issuePattern.matcher(text);
        while (matcher.find()) {
            Region region;
            String url;
            RepositoryId repo;
            if (index != -1 && (index < matcher.start() || index > matcher.end())) continue;
            String user = matcher.group(1);
            String project = matcher.group(2);
            String taskId = matcher.group(3);
            if (project == null && user != null && (repo = GitHub.getRepository((String)(url = repository.getUrl()))) != null) {
                project = repo.getName();
            }
            TaskRepository taskRepository = null;
            if (user == null && project == null) {
                taskRepository = repository;
            } else if (user != null && project != null) {
                String repositoryUrl = GitHub.createGitHubUrl((String)user, (String)project);
                taskRepository = TasksUi.getRepositoryManager().getRepository("github", repositoryUrl);
                if (taskRepository == null) {
                    repositoryUrl = GitHub.createGitHubUrlAlternate((String)user, (String)project);
                    taskRepository = TasksUi.getRepositoryManager().getRepository("github", repositoryUrl);
                }
            }
            if (taskRepository != null) {
                region = this.createRegion(textOffset, matcher);
                hyperlinks.add(new TaskHyperlink((IRegion)region, repository, taskId));
                continue;
            }
            if (user == null || project == null) continue;
            region = this.createRegion(textOffset, matcher);
            String url2 = String.valueOf(GitHub.createGitHubUrl((String)user, (String)project)) + "/issues/" + taskId;
            hyperlinks.add(new URLHyperlink((IRegion)region, url2));
        }
        return hyperlinks.toArray(new IHyperlink[0]);
    }

    private Region createRegion(int textOffset, Matcher matcher) {
        return new Region(matcher.start() + textOffset, matcher.end() - matcher.start());
    }

    public ITaskSearchPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new IssueRepositoryQueryPage(repository, null);
    }

    public String getTaskKindLabel(ITask task) {
        return Messages.IssueConnectorUi_LabelIssueKind;
    }
}

