/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.ui.CommonPluginImages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.ComplexClassifierProvider;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.OpenClassifierDialog;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.BrowserNode;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.MetamodelContainerNode;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.MetamodelNode;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.ResourceModelNode;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.WorkspaceMetamodelsDelta;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.WorkspaceMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.DelegatingPropertySource;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.metamodel.MetamodelImageRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider.EMFProviderUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelBrowser
implements IAdaptable {
    public static final int SHOW_PACKAGE_ONLY = 0;
    public static final int SHOW_PACKAGE_CONTENTS = 1;
    public static final int SHOW_CLASSIFIER_CONTENTS = 2;
    public static final int CHECK_STYLE = 4;
    public static final int DEFAULT = 3;
    private static final String FIND_CLASSIFIER_COMMAND_ID = "org.eclipse.m2m.qvt.oml.findClassifier";
    private static final String CONTEXT_ID = "org.eclipse.m2m.qvt.oml.metamodelBrowser";
    private static final String EXTENDED_CLASSES = " -> ";
    private static final String EXTENDED_CLASSES_SEPARATOR = ", ";
    private static final String INSTANCE_CLASS_NAME_START = " <";
    private static final String INSTANCE_CLASS_NAME_END = ">";
    private static final String NAME_AND_TYPE_SEPARATOR = " : ";
    private static final String PARAMETERS_START = "(";
    private static final String PARAMETERS_SEPARATOR = ", ";
    private static final String PARAMETERS_END = ")";
    private IContextService contextService;
    private IContextActivation contextActivation;
    private IHandlerService handlerService;
    private IHandlerActivation handlerActivation;
    private TreeViewer myViewer;
    private DrillDownAdapter myDrillDownAdapter;
    private IAction myDoubleClickAction;
    private IAction myCollapseAllAction;
    private IAction myShowInheritedFeaturesAction;
    private IAction myShowFullQualifiedNamesAction;
    private IAction myOpenClassifierAction;
    private PropertySheetPage myPropertySheetPage;
    private boolean myShowInheritedFeatures = false;
    private boolean myShowFullQualifiedNames = false;
    private int browserStyle;
    private ViewForm control;
    private IToolBarManager toolBarManager;
    private BrowserNode workspaceModels;

    public MetamodelBrowser(Composite parent) {
        this(parent, 3);
    }

    public MetamodelBrowser(Composite parent, int browserStyle) {
        Composite container = parent;
        this.browserStyle = browserStyle;
        this.control = new ViewForm(container, 0);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.control.setLayoutData((Object)data);
        this.toolBarManager = this.getToolBarManager();
        this.myViewer = this.createTreeViewer((Composite)this.control);
        this.control.setContent(this.myViewer.getControl());
        this.setupFilters();
        this.myViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        this.myViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.myViewer.setSorter(this.createSorter());
        this.myViewer.setInput(this.createInput());
        this.myDrillDownAdapter = new DrillDownAdapter(this.myViewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.myViewer.expandToLevel((Object)((BrowserNode)this.myViewer.getInput()).getChildren(false).get(0), 1);
        this.myViewer.getTree().setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.m2m.qvt.oml.metamodel_browser");
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MetamodelBrowser.this.dispose();
            }
        });
    }

    private void setupFilters() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        if ((this.browserStyle & 2) == 0) {
            filters.add(new ClassifierContentsFilter());
        }
        if ((this.browserStyle & 1) == 0) {
            filters.add(new PackageContentsFilter());
        }
        this.myViewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
    }

    public <T extends EModelElement> List<T> getModelElementSelection(Class<T> type) {
        ArrayList<EModelElement> result = new ArrayList<EModelElement>();
        for (EModelElement element : this.getModelElementSelection()) {
            if (!type.isInstance(element)) continue;
            result.add((EModelElement)type.cast(element));
        }
        return result;
    }

    public List<EModelElement> getModelElementSelection() {
        ArrayList<EModelElement> result = new ArrayList<EModelElement>();
        if (!this.getViewer().getSelection().isEmpty()) {
            for (BrowserNode selObj : (IStructuredSelection)this.getViewer().getSelection()) {
                if (!(selObj.getEObject() instanceof EModelElement)) continue;
                result.add((EModelElement)selObj.getEObject());
            }
        }
        if (this.getViewer() instanceof ContainerCheckedTreeViewer) {
            ContainerCheckedTreeViewer checkedViewer = (ContainerCheckedTreeViewer)this.getViewer();
            Object[] elements = checkedViewer.getCheckedElements();
            int i = 0;
            while (i < elements.length) {
                Object nextObject = elements[i];
                EModelElement modelElement = this.getElementAdapter(nextObject, EModelElement.class);
                if (modelElement instanceof EModelElement) {
                    result.add(modelElement);
                }
                ++i;
            }
        }
        return result;
    }

    public <T> T getElementAdapter(Object element, Class<T> adapter) {
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)element;
        Object adapted = adaptable.getAdapter(adapter);
        if (adapted != null) {
            return adapter.cast(adapted);
        }
        return null;
    }

    public Composite getControl() {
        return this.control;
    }

    protected IToolBarManager getToolBarManager() {
        if (this.toolBarManager != null) {
            return this.toolBarManager;
        }
        ToolBar tb = new ToolBar((Composite)this.control, 0x800000);
        this.toolBarManager = new ToolBarManager(tb);
        this.control.setTopLeft((Control)tb);
        return this.toolBarManager;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        int style = 772;
        if ((this.browserStyle & 4) != 0) {
            return new ContainerCheckedTreeViewer(parent, style);
        }
        return new TreeViewer(parent, style);
    }

    private static MetamodelContainerNode createRootMetamodelContainer() {
        return new MetamodelContainerNode(0, null, null, null);
    }

    protected IServiceLocator getServiceLocator() {
        return PlatformUI.getWorkbench();
    }

    public TreeViewer getViewer() {
        return this.myViewer;
    }

    protected ViewerSorter createSorter() {
        return new ViewerSorter(){

            public int category(Object element) {
                int category = super.category(element);
                if (((BrowserNode)element).getEObject() instanceof EPackage) {
                    return category - 1;
                }
                return category;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof MetamodelNode && e2 instanceof MetamodelNode) {
                    MetamodelNode n1 = (MetamodelNode)e1;
                    MetamodelNode n2 = (MetamodelNode)e2;
                    String key1 = n1.getDescriptor().getId();
                    String key2 = n2.getDescriptor().getId();
                    if (n1.getPackage() != null && MetamodelBrowser.isOK(n1.getDescriptor())) {
                        key1 = n1.getPackage().getName();
                    }
                    if (n2.getPackage() != null && MetamodelBrowser.isOK(n2.getDescriptor())) {
                        key2 = n2.getPackage().getName();
                    }
                    return key1.compareTo(key2);
                }
                return super.compare(viewer, e1, e2);
            }
        };
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return ((BrowserNode)parentElement).getChildren(MetamodelBrowser.this.myShowInheritedFeatures).toArray();
            }

            public Object getParent(Object element) {
                return ((BrowserNode)element).getParent();
            }

            public boolean hasChildren(Object element) {
                EPackage ePackage;
                BrowserNode node = (BrowserNode)element;
                if ((MetamodelBrowser.this.browserStyle & 2) == 0 && node.getEObject() instanceof EClassifier) {
                    return false;
                }
                if ((MetamodelBrowser.this.browserStyle & 1) == 0 && node.getEObject() instanceof EPackage && (ePackage = (EPackage)node.getEObject()).getESubpackages().isEmpty()) {
                    return false;
                }
                return ((BrowserNode)element).hasChildren(MetamodelBrowser.this.myShowInheritedFeatures);
            }

            public Object[] getElements(Object inputElement) {
                if (!this.hasChildren(inputElement)) {
                    return new Object[0];
                }
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected ILabelProvider createLabelProvider() {
        final ILabelProvider provider = EMFProviderUtil.createLabelProvider();
        return new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
                provider.removeListener(listener);
            }

            public boolean isLabelProperty(Object element, String property) {
                return provider.isLabelProperty((Object)((BrowserNode)element).getEObject(), property);
            }

            public void dispose() {
                provider.dispose();
            }

            public void addListener(ILabelProviderListener listener) {
                provider.addListener(listener);
            }

            public String getText(Object element) {
                String nsURI;
                BrowserNode node = (BrowserNode)element;
                String availableText = node.getText();
                if (availableText != null) {
                    return availableText;
                }
                EObject eObject = ((BrowserNode)element).getEObject();
                if (MetamodelBrowser.this.myShowFullQualifiedNames && eObject instanceof EClassifier) {
                    EClass eClass;
                    EClassifier eClassifier = (EClassifier)eObject;
                    StringBuilder text = new StringBuilder();
                    text.append(eClassifier.getName());
                    if (eClassifier instanceof EClass && !(eClass = (EClass)eClassifier).getESuperTypes().isEmpty()) {
                        text.append(MetamodelBrowser.EXTENDED_CLASSES);
                        Iterator iter = eClass.getESuperTypes().iterator();
                        while (iter.hasNext()) {
                            EClass eSuperType = (EClass)iter.next();
                            text.append(EmfUtil.getFullName((EClassifier)eSuperType));
                            if (!iter.hasNext()) continue;
                            text.append(", ");
                        }
                    }
                    if (eClassifier.getInstanceClassName() != null) {
                        text.append(MetamodelBrowser.INSTANCE_CLASS_NAME_START);
                        text.append(eClassifier.getInstanceClassName());
                        text.append(MetamodelBrowser.INSTANCE_CLASS_NAME_END);
                    }
                    return text.toString();
                }
                if (MetamodelBrowser.this.myShowFullQualifiedNames && eObject instanceof ETypedElement) {
                    ETypedElement eTypedElement = (ETypedElement)eObject;
                    StringBuilder text = new StringBuilder();
                    text.append(eTypedElement.getName());
                    if (eTypedElement instanceof EOperation) {
                        EOperation eOperation = (EOperation)eTypedElement;
                        text.append(MetamodelBrowser.PARAMETERS_START);
                        Iterator iter = eOperation.getEParameters().iterator();
                        while (iter.hasNext()) {
                            EParameter eParameter = (EParameter)iter.next();
                            text.append(EmfUtil.getFullName((EClassifier)eParameter.getEType()));
                            if (!iter.hasNext()) continue;
                            text.append(", ");
                        }
                        text.append(MetamodelBrowser.PARAMETERS_END);
                    }
                    if (eTypedElement.getEType() != null) {
                        text.append(MetamodelBrowser.NAME_AND_TYPE_SEPARATOR);
                        text.append(EmfUtil.getFullName((EClassifier)eTypedElement.getEType()));
                    }
                    return text.toString();
                }
                String text = provider.getText((Object)eObject);
                if (eObject instanceof EPackage && eObject.eContainer() == null && (nsURI = ((EPackage)eObject).getNsURI()) != null && nsURI.length() > 0) {
                    text = String.valueOf(text) + " (" + ((EPackage)eObject).getNsURI() + MetamodelBrowser.PARAMETERS_END;
                }
                return text;
            }

            public Image getImage(Object element) {
                Image image;
                BrowserNode node = (BrowserNode)element;
                Image availableImage = node.getImage();
                if (availableImage != null) {
                    return availableImage;
                }
                EObject eObject = node.getEObject();
                if (eObject instanceof EPackage && (image = MetamodelImageRegistry.INSTANCE.getImage((EPackage)eObject)) != null) {
                    return image;
                }
                return provider.getImage((Object)eObject);
            }
        };
    }

    protected Object createInput() {
        final Object[] input = new Object[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                input[0] = MetamodelBrowser.this.doCreateInput();
            }
        });
        assert (input.length == 1);
        return input[0];
    }

    protected Object doCreateInput() {
        MetamodelContainerNode rootContainer = MetamodelBrowser.createRootMetamodelContainer();
        MetamodelContainerNode globalRegistryNode = new MetamodelContainerNode(0, Messages.MetamodelBrowserView_platformMetamodelsLabel, CommonPluginImages.getInstance().getImage("metamodels"), rootContainer);
        this.workspaceModels = new MetamodelContainerNode(1, Messages.MetamodelBrowserView_workspaceMetamodelsLabel, CommonPluginImages.getInstance().getImage("metamodels"), rootContainer);
        HashMap<EPackage, Object> rootNodes = new HashMap<EPackage, Object>();
        String[] ids = MetamodelRegistry.getInstance().getMetamodelIds();
        int i = 0;
        while (i < ids.length) {
            try {
                IMetamodelDesc desc = MetamodelRegistry.getInstance().getMetamodelDesc(ids[i]);
                EPackage pack = desc.getModel();
                if (pack != null) {
                    if (pack.getESuperPackage() == null) {
                        rootNodes.put(pack, desc);
                    } else {
                        EPackage parent = EmfUtil.getRootPackage((EPackage)pack);
                        if (parent != pack && !rootNodes.containsKey(parent)) {
                            rootNodes.put(parent, new EmfMetamodelDesc(parent, parent.getNsURI()));
                        }
                    }
                }
            }
            catch (EmfException e) {
                CommonPlugin.log((Throwable)e);
            }
            ++i;
        }
        for (Map.Entry rootEntry : rootNodes.entrySet()) {
            globalRegistryNode.addChild(new MetamodelNode((IMetamodelDesc)rootEntry.getValue(), globalRegistryNode, false));
        }
        WorkspaceMetamodelProvider ws = new WorkspaceMetamodelProvider();
        IMetamodelDesc[] iMetamodelDescArray = ws.getMetamodels();
        int n = iMetamodelDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMetamodelDesc wsMModelDesc = iMetamodelDescArray[n2];
            this.workspaceModels.addChild(new ResourceModelNode(URI.createPlatformResourceURI((String)wsMModelDesc.getId(), (boolean)true), wsMModelDesc, this.workspaceModels));
            ++n2;
        }
        rootContainer.addChild(globalRegistryNode);
        rootContainer.addChild(this.workspaceModels);
        return rootContainer;
    }

    void update(WorkspaceMetamodelsDelta wsDelta) {
        if (!wsDelta.isEmpty()) {
            for (IPath iPath : wsDelta.getAdditions()) {
                this.metamodelFileAdded(iPath);
            }
            for (IPath iPath : wsDelta.getModifications()) {
                this.metamodelFileModified(iPath);
            }
            for (IPath iPath : wsDelta.getDeletions()) {
                this.metamodelDeletedFile(iPath);
            }
            for (Map.Entry entry : wsDelta.getMoves().entrySet()) {
                this.metamodelDeletedFile((IPath)entry.getKey());
                this.metamodelFileAdded((IPath)entry.getValue());
            }
            this.myViewer.refresh();
        }
    }

    protected void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MetamodelBrowser.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.myViewer.getControl());
        this.myViewer.getControl().setMenu(menu);
    }

    protected void contributeToActionBars() {
        this.fillLocalToolBar(this.toolBarManager);
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.myDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        this.myDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add(this.myCollapseAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.myShowInheritedFeaturesAction);
        manager.add(this.myShowFullQualifiedNamesAction);
        if (this.myOpenClassifierAction != null) {
            manager.add((IContributionItem)new Separator());
            manager.add(this.myOpenClassifierAction);
        }
        manager.update(true);
    }

    protected void makeActions() {
        this.myDoubleClickAction = new Action(){

            public void run() {
            }
        };
        this.myCollapseAllAction = new Action(){

            public void run() {
                MetamodelBrowser.this.myViewer.collapseAll();
            }
        };
        this.myCollapseAllAction.setToolTipText(Messages.MetamodelBrowserView_collapseAll);
        this.myCollapseAllAction.setImageDescriptor(CommonPluginImages.getInstance().getImageDescriptor("collapseall"));
        this.myShowInheritedFeaturesAction = new Action(null, 2){

            public void run() {
                MetamodelBrowser.this.myShowInheritedFeatures = this.isChecked();
                MetamodelBrowser.this.myViewer.refresh();
            }
        };
        this.myShowInheritedFeaturesAction.setToolTipText(Messages.MetamodelBrowserView_showInheritedFeatures);
        this.myShowInheritedFeaturesAction.setImageDescriptor(CommonPluginImages.getInstance().getImageDescriptor("showinherf"));
        this.myShowFullQualifiedNamesAction = new Action(null, 2){

            public void run() {
                MetamodelBrowser.this.myShowFullQualifiedNames = this.isChecked();
                MetamodelBrowser.this.myViewer.refresh();
            }
        };
        this.myShowFullQualifiedNamesAction.setToolTipText(Messages.MetamodelBrowserView_showFullQualifiedNames);
        this.myShowFullQualifiedNamesAction.setImageDescriptor(CommonPluginImages.getInstance().getImageDescriptor("showfullq"));
        if ((this.browserStyle & 1) != 0) {
            this.myOpenClassifierAction = this.createFindClassifierAction(this.myViewer);
            this.contextService = (IContextService)this.getServiceLocator().getService(IContextService.class);
            this.contextService.getShellType(this.control.getShell());
            this.contextActivation = this.contextService.activateContext(CONTEXT_ID);
            this.handlerService = (IHandlerService)this.getServiceLocator().getService(IHandlerService.class);
            this.handlerActivation = this.handlerService.activateHandler(FIND_CLASSIFIER_COMMAND_ID, (IHandler)new ActionHandler(this.myOpenClassifierAction));
        }
    }

    private Display getDisplay() {
        return this.getControl().getDisplay();
    }

    private void dispose() {
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
        }
        if (this.handlerActivation != null) {
            this.handlerService.deactivateHandler(this.handlerActivation);
        }
    }

    private IAction createFindClassifierAction(final TreeViewer viewer) {
        Action action = new Action(){

            public void run() {
                ISelection selection;
                OpenClassifierDialog dialog;
                final ArrayList rootPackages = new ArrayList();
                if (viewer != null) {
                    BusyIndicator.showWhile((Display)MetamodelBrowser.this.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            List<BrowserNode> rootChildren = ((BrowserNode)viewer.getInput()).getChildren(false);
                            int i = 0;
                            while (i < rootChildren.size()) {
                                MetamodelBrowser.collectSearchScopePackages(rootChildren.get(i), rootPackages);
                                ++i;
                            }
                        }
                    });
                }
                if ((dialog = new OpenClassifierDialog(viewer.getControl().getShell(), new ComplexClassifierProvider(Collections.unmodifiableList(rootPackages)))).open() == 0 && !(selection = dialog.getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
                    MetamodelBrowser.this.navigate((EModelElement)((EClassifier)((IStructuredSelection)selection).getFirstElement()));
                }
            }
        };
        action.setToolTipText(Messages.MetamodelBrowserView_openClassifier);
        action.setImageDescriptor(CommonPluginImages.getInstance().getImageDescriptor("opentype"));
        action.setActionDefinitionId(FIND_CLASSIFIER_COMMAND_ID);
        return action;
    }

    private static void collectSearchScopePackages(BrowserNode browserNode, List<EPackage> result) {
        if (browserNode instanceof MetamodelContainerNode) {
            List<BrowserNode> mmodelNodes = browserNode.getChildren(false);
            int i = 0;
            while (i < mmodelNodes.size()) {
                BrowserNode mmNode = mmodelNodes.get(i);
                MetamodelBrowser.collectSearchScopePackages(mmNode, result);
                ++i;
            }
        } else if (browserNode instanceof MetamodelNode) {
            EPackage ePackage = ((MetamodelNode)browserNode).getSearchScopePackage();
            if (ePackage != null) {
                result.add(ePackage);
            }
        } else if (browserNode.getEObject() instanceof EClassifier) {
            EClassifier eClassifier = (EClassifier)browserNode.getEObject();
            EPackage scope = eClassifier.getEPackage();
            if (scope != null) {
                result.add(scope);
            }
        } else if (browserNode.getEObject() instanceof EPackage) {
            result.add((EPackage)browserNode.getEObject());
        }
    }

    public EObject navigate(EModelElement eModelElement) {
        if (this.myViewer == null) {
            return null;
        }
        BrowserNode targetNode = null;
        Object root = this.myViewer.getInput();
        if (root instanceof MetamodelContainerNode) {
            MetamodelContainerNode metamodelContainerNode = (MetamodelContainerNode)root;
            targetNode = metamodelContainerNode.resolve(eModelElement);
        } else if (root instanceof BrowserNode) {
            BrowserNode browserNode = (BrowserNode)root;
            targetNode = BrowserNode.findNodeForInstance(browserNode, (EObject)eModelElement);
        }
        if (targetNode != null) {
            this.myViewer.setSelection((ISelection)new StructuredSelection((Object)targetNode), true);
            this.myViewer.expandToLevel((Object)targetNode, 1);
            this.myViewer.getControl().setFocus();
            return targetNode.getEObject();
        }
        return null;
    }

    protected void hookDoubleClickAction() {
        this.myViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MetamodelBrowser.this.myDoubleClickAction.run();
            }
        });
    }

    public boolean setFocus() {
        if (this.myViewer != null) {
            this.myViewer.getControl().setFocus();
        }
        return false;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return null;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.myPropertySheetPage == null) {
            this.myPropertySheetPage = new PropertySheetPage();
            final IPropertySourceProvider provider = EMFProviderUtil.createAdapterFactoryContentProvider();
            this.myPropertySheetPage.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    IPropertySource source = null;
                    source = object instanceof BrowserNode ? provider.getPropertySource((Object)((BrowserNode)object).getEObject()) : provider.getPropertySource(object);
                    if (source == null) {
                        return null;
                    }
                    return new DelegatingPropertySource(source);
                }
            });
        }
        return this.myPropertySheetPage;
    }

    private void metamodelFileAdded(IPath ecoreFilePath) {
        if (this.workspaceModels == null) {
            return;
        }
        URI resURI = URI.createPlatformResourceURI((String)ecoreFilePath.toString(), (boolean)false);
        WorkspaceMetamodelProvider ws = new WorkspaceMetamodelProvider();
        IMetamodelDesc modelFileDesc = ws.getMetamodel(ecoreFilePath.toPortableString());
        this.workspaceModels.addChild(new ResourceModelNode(resURI, modelFileDesc, this.workspaceModels));
    }

    private void metamodelDeletedFile(IPath ecoreFilePath) {
        ResourceModelNode resourceModelNode = this.findResourceMetamodelNode(ecoreFilePath);
        if (resourceModelNode != null) {
            resourceModelNode.getParent().removeChild(resourceModelNode);
        }
    }

    private void metamodelFileModified(IPath ecoreFilePath) {
        ResourceModelNode resourceModelNode = this.findResourceMetamodelNode(ecoreFilePath);
        if (resourceModelNode != null) {
            URI resourceURI = resourceModelNode.uri;
            WorkspaceMetamodelProvider ws = new WorkspaceMetamodelProvider();
            IMetamodelDesc modelFileDesc = ws.getMetamodel(ecoreFilePath.toPortableString());
            ResourceModelNode newNode = new ResourceModelNode(resourceURI, modelFileDesc, this.workspaceModels);
            resourceModelNode.getParent().removeChild(resourceModelNode);
            resourceModelNode.getParent().addChild(newNode);
            this.myViewer.collapseToLevel((Object)resourceModelNode, 2);
        }
    }

    private ResourceModelNode findResourceMetamodelNode(IPath ecoreFilePath) {
        if (this.workspaceModels == null) {
            return null;
        }
        URI resURI = URI.createPlatformResourceURI((String)ecoreFilePath.toString(), (boolean)false);
        ListIterator<BrowserNode> it = this.workspaceModels.getChildren(false).listIterator();
        while (it.hasNext()) {
            BrowserNode child = it.next();
            if (!(child instanceof ResourceModelNode)) continue;
            ResourceModelNode resourceModelNode = (ResourceModelNode)child;
            if (!resURI.equals(resourceModelNode.uri)) continue;
            return resourceModelNode;
        }
        return null;
    }

    private static boolean isOK(IMetamodelDesc metamodelDesc) {
        return EmfUtilPlugin.isSuccess((Diagnostic)metamodelDesc.getLoadStatus());
    }

    private static class ClassifierContentsFilter
    extends ViewerFilter {
        private ClassifierContentsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            BrowserNode node = (BrowserNode)parentElement;
            return !(node.getEObject() instanceof EClass);
        }
    }

    private static class PackageContentsFilter
    extends ViewerFilter {
        private PackageContentsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            BrowserNode node = (BrowserNode)element;
            BrowserNode parentNode = (BrowserNode)parentElement;
            return !(parentNode.getEObject() instanceof EPackage) || node.getEObject() instanceof EPackage;
        }
    }
}

