/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.toolkit.enums.ValueSets;

public class KeyAcceptor {
    public static final int MAPPING_KEY_COMB = 1;
    public static final int CHECKMODE_KEY_COMB = 2;
    public static final int CHECKCOMP_KEY_COMB = 3;

    public int accept(InputEvent event) {
        int keyMod = 0;
        if (event.isAltDown()) {
            keyMod |= 0x200;
        }
        if (event.isShiftDown()) {
            keyMod |= 0x40;
        }
        if (event.isControlDown()) {
            keyMod |= 0x80;
        }
        if (event.isAltGraphDown()) {
            keyMod |= 0x2000;
        }
        int inputCode = 0;
        if (event instanceof KeyEvent) {
            inputCode = ((KeyEvent)event).getKeyCode();
        } else if (event instanceof MouseEvent) {
            int button = ((MouseEvent)event).getButton();
            switch (button) {
                case 1: {
                    inputCode = ValueSets.InteractionMode.primary.rcIntValue();
                    break;
                }
                case 2: {
                    inputCode = ValueSets.InteractionMode.tertiary.rcIntValue();
                    break;
                }
                case 3: {
                    inputCode = ValueSets.InteractionMode.secondary.rcIntValue();
                    break;
                }
            }
        }
        if ((inputCode == AUTServerConfiguration.getInstance().getMappingKey() || inputCode == AUTServerConfiguration.getInstance().getMappingMouseButton()) && keyMod == AUTServerConfiguration.getInstance().getMappingKeyMod()) {
            return 1;
        }
        if (inputCode == AUTServerConfiguration.getInstance().getCheckModeKey() && keyMod == AUTServerConfiguration.getInstance().getCheckModeKeyMod()) {
            return 2;
        }
        if (inputCode == AUTServerConfiguration.getInstance().getCheckCompKey() && keyMod == AUTServerConfiguration.getInstance().getCheckCompKeyMod()) {
            return 3;
        }
        return 0;
    }

    public boolean isSingleLineTrigger(KeyEvent event) {
        boolean isSingleTrigger = false;
        int keycode = event.getKeyCode();
        int modifier = event.getModifiers();
        SortedSet singleTrigger = AUTServerConfiguration.getInstance().getSingleLineTrigger();
        isSingleTrigger = this.isTrigger(singleTrigger, keycode, modifier);
        return isSingleTrigger;
    }

    public boolean isMultiLineTrigger(KeyEvent event) {
        boolean isMultiTrigger = false;
        int keycode = event.getKeyCode();
        int modifier = event.getModifiers();
        SortedSet multiTrigger = AUTServerConfiguration.getInstance().getMultiLineTrigger();
        isMultiTrigger = this.isTrigger(multiTrigger, keycode, modifier);
        return isMultiTrigger;
    }

    public boolean isTrigger(SortedSet triggerSet, int key, int modifiers) {
        boolean isTrigger = false;
        int triggerCode = 0;
        int triggerModMask = 0;
        Iterator it = triggerSet.iterator();
        while (it.hasNext()) {
            String trigger = it.next().toString().toUpperCase();
            if (trigger.indexOf("+") != -1) {
                String[] keys = trigger.split("\\+");
                switch (keys.length) {
                    case 2: {
                        triggerModMask = this.getModifierMask(keys[0]);
                        triggerCode = this.getKeyCode(keys[1]);
                        break;
                    }
                    case 3: {
                        triggerModMask = this.getModifierMask(keys[0]) | this.getModifierMask(keys[1]);
                        triggerCode = this.getKeyCode(keys[2]);
                        break;
                    }
                    case 4: {
                        triggerModMask = this.getModifierMask(keys[0]) | this.getModifierMask(keys[1]) | this.getModifierMask(keys[2]);
                        triggerCode = this.getKeyCode(keys[3]);
                    }
                }
            } else {
                triggerModMask = 0;
                triggerCode = this.getKeyCode(trigger);
            }
            if (key != triggerCode || modifiers != triggerModMask) continue;
            isTrigger = true;
        }
        return isTrigger;
    }

    public int getKeyCode(String keyCodeName) {
        int code = -1;
        String codeName = "VK_" + keyCodeName;
        if (codeName.equals("VK_CTRL")) {
            codeName = "VK_CONTROL";
        }
        try {
            code = KeyEvent.class.getField(codeName).getInt(KeyEvent.class);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return code;
    }

    public int getModifierMask(String modifierName) {
        int code = -1;
        String codeName = String.valueOf(modifierName) + "_MASK";
        try {
            code = InputEvent.class.getField(codeName).getInt(InputEvent.class);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return code;
    }
}

