/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.rename.AbstractRenameComponentNameHandler;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameLogicalNameHandler
extends AbstractRenameComponentNameHandler {
    public Object executeImpl(final ExecutionEvent event) {
        final IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor instanceof ObjectMappingMultiPageEditor) {
            ObjectMappingMultiPageEditor omEditor = (ObjectMappingMultiPageEditor)activeEditor;
            final IComponentNamePO compName = this.getSelectedComponentName();
            if (compName != null) {
                final JBEditorHelper editorHelper = omEditor.getEditorHelper();
                editorHelper.doEditorOperation(new IEditorOperation(){

                    @Override
                    public void run(IPersistentObject workingPo) {
                        String newName = RenameLogicalNameHandler.this.getNewName(event, compName);
                        if (newName != null) {
                            RenameLogicalNameHandler.this.rename(editorHelper.getEditSupport().getCache(), compName.getGuid(), newName);
                            editorHelper.setDirty(true);
                            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.onlyInEditor);
                            ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
                            if (selectionProvider != null) {
                                ISelection currentSelection = selectionProvider.getSelection();
                                selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                                selectionProvider.setSelection(currentSelection);
                            }
                        }
                    }
                });
            }
        }
        return null;
    }
}

