/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.core.plugin.messages.Axis2CoreUIMessages;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;

public class RuntimePropertyUtils {
    private static File PropertiesFileDir;
    private static File serverPropertiesFile;
    private static File statusPropertyFile;
    private static File warPropertyFile;
    private static IStatus status;
    private static Properties properties;

    private static void init() {
        PropertiesFileDir = new File(Axis2CoreUtils.tempAxis2Directory());
        if (!PropertiesFileDir.exists()) {
            PropertiesFileDir.mkdirs();
        }
        properties = new Properties();
    }

    private static void serverPropertiesFileInit() throws IOException {
        serverPropertiesFile = new File(Axis2CoreUtils.tempAxis2WebappFileLocation());
        if (!serverPropertiesFile.exists()) {
            serverPropertiesFile.createNewFile();
        }
        properties.load(new FileInputStream(serverPropertiesFile));
    }

    private static void statusPropertiesFileInit() throws IOException {
        statusPropertyFile = new File(Axis2CoreUtils.tempRuntimeStatusFileLocation());
        if (!statusPropertyFile.exists()) {
            statusPropertyFile.createNewFile();
        }
        properties.load(new FileInputStream(statusPropertyFile));
    }

    private static void warPropertiesFileInit() throws IOException {
        warPropertyFile = new File(Axis2CoreUtils.tempWarStatusFileLocation());
        if (!warPropertyFile.exists()) {
            warPropertyFile.createNewFile();
        }
        properties.load(new FileInputStream(warPropertyFile));
    }

    public static IStatus writeServerPathToPropertiesFile(String axis2Path) {
        String axis2PathNew = null;
        axis2PathNew = axis2Path.indexOf("\\") != -1 ? axis2Path.replace(File.separator, String.valueOf(File.separator) + File.separator) : axis2Path;
        try {
            RuntimePropertyUtils.init();
            RuntimePropertyUtils.serverPropertiesFileInit();
            if (properties.size() != 0 && properties.containsKey("path")) {
                properties.remove("path");
            }
            Axis2CoreUtils.writePropertyToFile(serverPropertiesFile, "path", axis2PathNew);
        }
        catch (FileNotFoundException fileNotFoundException) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException iOException) {
            RuntimePropertyUtils.updateStatusError();
        }
        return status;
    }

    public static String getServerPathFromPropertiesFile() {
        RuntimePropertyUtils.init();
        String serverPath = null;
        serverPropertiesFile = new File(Axis2CoreUtils.tempAxis2WebappFileLocation());
        if (!serverPropertiesFile.exists()) {
            RuntimePropertyUtils.updateStatusError();
        }
        try {
            properties.load(new FileInputStream(serverPropertiesFile));
            if (properties.containsKey("path")) {
                serverPath = properties.getProperty("path");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException iOException) {
            RuntimePropertyUtils.updateStatusError();
        }
        return serverPath;
    }

    public static IStatus writeServerStausToPropertiesFile(String runtimeStatus) {
        try {
            RuntimePropertyUtils.init();
            RuntimePropertyUtils.statusPropertiesFileInit();
            if (properties.size() != 0 && properties.containsKey("status")) {
                properties.remove("status");
            }
            Axis2CoreUtils.writePropertyToFile(statusPropertyFile, "status", runtimeStatus);
        }
        catch (FileNotFoundException fileNotFoundException) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException iOException) {
            RuntimePropertyUtils.updateStatusError();
        }
        return status;
    }

    public static IStatus writeWarStausToPropertiesFile(boolean warStatus) {
        try {
            RuntimePropertyUtils.init();
            RuntimePropertyUtils.warPropertiesFileInit();
            if (properties.size() != 0 && properties.containsKey("status")) {
                properties.remove("status");
            }
            Axis2CoreUtils.writePropertyToFile(warPropertyFile, "status", String.valueOf(warStatus));
        }
        catch (FileNotFoundException fileNotFoundException) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException iOException) {
            RuntimePropertyUtils.updateStatusError();
        }
        return status;
    }

    public static boolean getWarStatusFromPropertiesFile() {
        RuntimePropertyUtils.init();
        boolean warStatus = false;
        warPropertyFile = new File(Axis2CoreUtils.tempWarStatusFileLocation());
        if (!warPropertyFile.exists()) {
            RuntimePropertyUtils.updateStatusError();
        }
        try {
            properties.load(new FileInputStream(warPropertyFile));
            if (properties.containsKey("status")) {
                warStatus = Boolean.parseBoolean(properties.getProperty("status"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            RuntimePropertyUtils.updateStatusError();
        }
        catch (IOException iOException) {
            RuntimePropertyUtils.updateStatusError();
        }
        return warStatus;
    }

    private static void updateStatusError() {
        status = new Status(4, "id", 0, Axis2CoreUIMessages.ERROR_INVALID_AXIS2_SERVER_LOCATION, null);
    }
}

