/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableElement;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableElementWithContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditorInput
implements IEditorInput {
    private final List<TableElement> elements;
    private final List<EStructuralFeature> fFeatures;
    private final BrowserConfiguration browserConfiguration;
    private final String description;
    private HashSet<EClass> metaclasses;

    public TableEditorInput(BrowserConfiguration browserConfiguration, List<TableElement> tableElements, String description) {
        this.browserConfiguration = browserConfiguration;
        this.elements = tableElements;
        this.description = description;
        this.metaclasses = new HashSet();
        for (TableElement tableElement : tableElements) {
            Object element = tableElement.getElement();
            if (!(element instanceof EObject)) continue;
            EObject eObject = (EObject)element;
            this.metaclasses.add(eObject.eClass());
            List facets = this.browserConfiguration.getAppearanceConfiguration().getFacetContext().getFacets(eObject);
            this.metaclasses.addAll(facets);
        }
        BasicEList<EStructuralFeature> features = new BasicEList<EStructuralFeature>(){
            private static final long serialVersionUID = -2429276823183270956L;

            protected boolean isUnique() {
                return true;
            }
        };
        for (EClass eClass : this.metaclasses) {
            features.addAll((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        }
        this.fFeatures = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)features);
    }

    public TableEditorInput(BrowserConfiguration browserConfiguration, EClass eClass, String description) {
        this.browserConfiguration = browserConfiguration;
        this.description = description;
        InstancesForMetaclass instances = this.browserConfiguration.getInstancesForMetaclasses().getInstancesForMetaclass(eClass);
        this.elements = new ArrayList<TableElement>();
        ArrayList<EObject> instanceElements = instances.getElements();
        for (EObject eObject : instanceElements) {
            this.elements.add(new TableElement(eObject));
        }
        this.fFeatures = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
    }

    public List<TableElement> getElements() {
        return this.elements;
    }

    public List<EStructuralFeature> getFeatures() {
        return this.fFeatures;
    }

    public String getDescription() {
        return this.description;
    }

    public BrowserConfiguration getBrowserConfiguration() {
        return this.browserConfiguration;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return Messages.TableEditorInput_editorName_TableViewer;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return Messages.TableEditorInput_tooltip_TableViewer;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public EClass[] getMetaclasses() {
        return this.metaclasses.toArray(new EClass[this.metaclasses.size()]);
    }

    public ElementsDescription getElementsDescription() {
        ElementsDescription elementsDescription = new ElementsDescription();
        for (TableElement tableElement : this.elements) {
            Object element;
            if (tableElement instanceof TableElementWithContext) {
                elementsDescription.containsContexts = true;
            }
            if ((element = tableElement.getElement()) instanceof EObject) {
                elementsDescription.containsEObjects = true;
                continue;
            }
            elementsDescription.containsPrimitiveTypes = true;
        }
        return elementsDescription;
    }

    public static class ElementsDescription {
        private boolean containsEObjects;
        private boolean containsPrimitiveTypes;
        private boolean containsContexts;

        public boolean containsEObjects() {
            return this.containsEObjects;
        }

        public boolean containsPrimitiveTypes() {
            return this.containsPrimitiveTypes;
        }

        public boolean containsContexts() {
            return this.containsContexts;
        }
    }
}

