/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable;

import java.util.List;
import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.ICellEditHandler;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.style.IStyle;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditor;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableCellEditorAdapter
implements ICellEditor {
    private final IModelCellEditor modelCellEditor;
    private final List<Column> columns;
    private Control control;
    private Composite fParent;
    private Object element;
    private IFacetManager facetManager;

    public NatTableCellEditorAdapter(IModelCellEditor modelCellEditor, List<Column> columns, IFacetManager facetContext) {
        this.modelCellEditor = modelCellEditor;
        this.columns = columns;
        this.facetManager = facetContext;
    }

    public Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue, IDisplayConverter displayConverter, IStyle cellStyle, IDataValidator dataValidator, final ICellEditHandler editHandler, int colIndex, int rowIndex) {
        this.fParent = parent;
        IModelCellEditHandler modelCellEditHandler = new IModelCellEditHandler(){

            public void commit() {
                editHandler.commit(SelectionLayer.MoveDirectionEnum.NONE, true);
            }
        };
        Column column = this.columns.get(colIndex);
        if (column instanceof FeatureColumn) {
            FeatureColumn featureColumn = (FeatureColumn)column;
            ETypedElement feature = featureColumn.getFeature();
            IGridElement gridElement = (IGridElement)originalCanonicalValue;
            this.element = gridElement.getElement();
            if (this.element instanceof EObject) {
                EObject eObject = (EObject)this.element;
                Object value = null;
                if (feature.eContainer() instanceof Facet) {
                    try {
                        value = this.facetManager.getOrInvoke(eObject, feature, Object.class);
                    }
                    catch (Exception e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                } else {
                    try {
                        value = this.facetManager.getOrInvoke(eObject, feature, Object.class);
                    }
                    catch (FacetManagerException e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                        value = "!!! Error, cf log !!!";
                    }
                }
                if (feature instanceof EStructuralFeature) {
                    EStructuralFeature structuralFeature = (EStructuralFeature)feature;
                    this.control = this.modelCellEditor.activateCell(parent, value, modelCellEditHandler, structuralFeature, eObject);
                    return this.control;
                }
                throw new IllegalStateException("Only EStructuralFeature value cells are editable");
            }
            throw new IllegalArgumentException("not an EObject");
        }
        this.control = new Composite(parent, 0);
        return this.control;
    }

    public void setCanonicalValue(Object canonicalValue) {
        throw new UnsupportedOperationException();
    }

    public Object getCanonicalValue() {
        return this.modelCellEditor.getValue();
    }

    public void close() {
        if (this.fParent != null && !this.fParent.isDisposed()) {
            this.fParent.forceFocus();
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
    }

    public boolean isClosed() {
        return this.control == null || this.control.isDisposed();
    }
}

