/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.view.linewrapper;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.provider.ECPStringModifier;

public class ECPStringLineWrapper
implements ECPStringModifier {
    private static final int MAX_LINE_LENGTH = 80;

    public String modifyString(String text, EStructuralFeature.Setting setting) {
        String[] textLines = text.split("\\r?\\n");
        StringBuilder allLines = new StringBuilder();
        int j = 0;
        while (j < textLines.length) {
            String line = textLines[j];
            if (j != 0) {
                allLines.append("\n");
            }
            String wrappedLine = this.wrapLine(line);
            allLines.append(wrappedLine);
            ++j;
        }
        return allLines.toString();
    }

    private String wrapLine(String line) {
        StringBuilder sb = new StringBuilder(line);
        int i = 0;
        while (i + 80 < sb.length()) {
            if ((i = sb.lastIndexOf("\n", i + 80)) == -1) {
                i = 0;
            }
            i = sb.lastIndexOf(" ", i + 80);
            int multiplicator = 2;
            while (i == -1) {
                i = sb.lastIndexOf(" ", i + multiplicator * 80);
                if (++multiplicator * 80 > sb.length()) break;
            }
            if (i == -1) break;
            sb.replace(i, i + 1, "\n");
        }
        String wrappedLine = sb.toString();
        return wrappedLine;
    }

    public double getPriority() {
        return 0.0;
    }
}

