/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.common.revision.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class StoreAccessorBase
extends Lifecycle
implements IStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, StoreAccessorBase.class);
    private Store store;
    private Object context;
    private boolean reader;
    private List<IStoreAccessor.CommitContext> commitContexts = new ArrayList<IStoreAccessor.CommitContext>();

    private StoreAccessorBase(Store store, Object context, boolean reader) {
        this.store = store;
        this.context = context;
        this.reader = reader;
    }

    protected StoreAccessorBase(Store store, ISession session) {
        this(store, session, true);
    }

    protected StoreAccessorBase(Store store, ITransaction transaction) {
        this(store, transaction, false);
    }

    void setContext(Object context) {
        this.context = context;
    }

    public Store getStore() {
        return this.store;
    }

    public boolean isReader() {
        return this.reader;
    }

    public InternalSession getSession() {
        if (this.context instanceof ITransaction) {
            return (InternalSession)((ITransaction)this.context).getSession();
        }
        return (InternalSession)this.context;
    }

    public ITransaction getTransaction() {
        if (this.context instanceof ITransaction) {
            return (ITransaction)this.context;
        }
        return null;
    }

    public void release() {
        this.store.releaseAccessor(this);
        this.commitContexts.clear();
    }

    public final void write(InternalCommitContext context, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing transaction: {0}", new Object[]{this.getTransaction()});
        }
        this.commitContexts.add(context);
        this.doWrite(context, monitor);
    }

    protected abstract void doWrite(InternalCommitContext var1, OMMonitor var2);

    public final void commit(OMMonitor monitor) {
        this.doCommit(monitor);
        long latest = 0L;
        long latestNonLocal = 0L;
        for (IStoreAccessor.CommitContext commitContext : this.commitContexts) {
            CDOBranch branch;
            CDOBranchPoint branchPoint = commitContext.getBranchPoint();
            long timeStamp = branchPoint.getTimeStamp();
            if (timeStamp > latest) {
                latest = timeStamp;
            }
            if ((branch = branchPoint.getBranch()).isLocal() || timeStamp <= latestNonLocal) continue;
            latestNonLocal = timeStamp;
        }
        this.store.setLastCommitTime(latest);
        this.store.setLastNonLocalCommitTime(latestNonLocal);
    }

    protected abstract void doCommit(OMMonitor var1);

    public final void rollback() {
        if (TRACER.isEnabled()) {
            TRACER.format("Rolling back transaction: {0}", new Object[]{this.getTransaction()});
        }
        for (IStoreAccessor.CommitContext commitContext : this.commitContexts) {
            this.doRollback(commitContext);
        }
    }

    protected abstract void doRollback(IStoreAccessor.CommitContext var1);

    public CDOID readResourceID(CDOID folderID, String name, CDOBranchPoint branchPoint) {
        IStoreAccessor.QueryResourcesContext.ExactMatch context = Store.createExactMatchContext(folderID, name, branchPoint);
        this.queryResources(context);
        return context.getResourceID();
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        CommitDataRevisionHandler handler = new CommitDataRevisionHandler(this, timeStamp);
        return handler.getCommitData();
    }

    public void addIDMappings(InternalCommitContext commitContext, OMMonitor monitor) {
        try {
            InternalCDORevision[] newObjects = commitContext.getNewObjects();
            monitor.begin((double)newObjects.length);
            InternalCDORevision[] internalCDORevisionArray = newObjects;
            int n = newObjects.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                CDOID id = revision.getID();
                if (id instanceof CDOIDTemp) {
                    CDOIDTemp oldID = (CDOIDTemp)id;
                    CDOID newID = this.getNextCDOID((CDORevision)revision);
                    if (CDOIDUtil.isNull((CDOID)newID) || newID.isTemporary()) {
                        throw new IllegalStateException("newID=" + newID);
                    }
                    commitContext.addIDMapping((CDOID)oldID, newID);
                }
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract CDOID getNextCDOID(CDORevision var1);

    protected void doPassivate() throws Exception {
    }

    protected void doUnpassivate() throws Exception {
    }

    public static class CommitDataRevisionHandler
    implements CDORevisionHandler {
        private IStoreAccessor storeAccessor;
        private long timeStamp;
        private InternalCDORevisionManager revisionManager;
        private List<CDOPackageUnit> newPackageUnits = new ArrayList<CDOPackageUnit>();
        private List<CDOIDAndVersion> newObjects = new ArrayList<CDOIDAndVersion>();
        private List<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>();
        private List<CDOIDAndVersion> detachedObjects = new ArrayList<CDOIDAndVersion>();

        public CommitDataRevisionHandler(IStoreAccessor storeAccessor, long timeStamp) {
            InternalCDOPackageUnit[] packageUnits;
            this.storeAccessor = storeAccessor;
            this.timeStamp = timeStamp;
            InternalStore store = (InternalStore)storeAccessor.getStore();
            InternalRepository repository = store.getRepository();
            this.revisionManager = repository.getRevisionManager();
            InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry(false);
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits = packageRegistry.getPackageUnits(timeStamp, timeStamp);
            int n = packageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                if (!packageUnit.isSystem()) {
                    this.newPackageUnits.add((CDOPackageUnit)packageUnit);
                }
                ++n2;
            }
        }

        public CDOCommitData getCommitData() {
            this.storeAccessor.handleRevisions(null, null, this.timeStamp, true, this);
            return CDOCommitInfoUtil.createCommitData(this.newPackageUnits, this.newObjects, this.changedObjects, this.detachedObjects);
        }

        public boolean handleRevision(CDORevision rev) {
            if (rev instanceof DetachedCDORevision) {
                CDOIDAndVersionImpl copy = new CDOIDAndVersionImpl(rev.getID(), rev.getVersion());
                this.detachedObjects.add((CDOIDAndVersion)copy);
                return true;
            }
            if (rev.getTimeStamp() != this.timeStamp) {
                throw new IllegalArgumentException("Invalid revision time stamp: " + CDOCommonUtil.formatTimeStamp((long)rev.getTimeStamp()));
            }
            InternalCDORevision revision = (InternalCDORevision)rev;
            CDOID id = revision.getID();
            InternalCDOBranch branch = revision.getBranch();
            int version = revision.getVersion();
            if (version > 1) {
                CDOBranchVersion oldVersion = branch.getVersion(version - 1);
                InternalCDORevision oldRevision = this.revisionManager.getRevisionByVersion(id, oldVersion, -1, true);
                InternalCDORevisionDelta delta = revision.compare((CDORevision)oldRevision);
                this.changedObjects.add((CDORevisionKey)delta);
            } else {
                InternalCDORevision oldRevision = this.getRevisionFromBase(id, (CDOBranch)branch);
                if (oldRevision != null) {
                    InternalCDORevisionDelta delta = revision.compare((CDORevision)oldRevision);
                    this.changedObjects.add((CDORevisionKey)delta);
                } else {
                    InternalCDORevision newRevision = revision.copy();
                    newRevision.setRevised(0L);
                    this.newObjects.add((CDOIDAndVersion)newRevision);
                }
            }
            return true;
        }

        private InternalCDORevision getRevisionFromBase(CDOID id, CDOBranch branch) {
            if (branch.isMainBranch()) {
                return null;
            }
            CDOBranchPoint base = branch.getBase();
            InternalCDORevision revision = this.revisionManager.getRevision(id, base, -1, 0, true);
            if (revision == null) {
                revision = this.getRevisionFromBase(id, base.getBranch());
            }
            return revision;
        }
    }
}

