/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.internal.ui.actions.ViewFilterAction;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class ShowFullPathsAction
extends ViewFilterAction {
    @Override
    protected String getPreferenceKey() {
        return "org.eclipse.cdt.debug.ui.cDebug.show_full_paths";
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return true;
    }

    @Override
    public void run(IAction action) {
        IDebugModelPresentation pres;
        final StructuredViewer viewer = this.getStructuredViewer();
        IDebugView view = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (view != null && (pres = view.getPresentation(CDIDebugModel.getPluginIdentifier())) != null) {
            pres.setAttribute("DISPLAY_FULL_PATHS", (Object)this.getValue());
            BusyIndicator.showWhile((Display)viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    String key = String.valueOf(ShowFullPathsAction.this.getView().getSite().getId()) + "." + ShowFullPathsAction.this.getPreferenceKey();
                    ShowFullPathsAction.this.getPreferenceStore().setValue(key, ShowFullPathsAction.this.getValue());
                    CDebugUIPlugin.getDefault().savePluginPreferences();
                    viewer.refresh();
                }
            });
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        IDebugView view = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (view instanceof LaunchView) {
            ILaunch[] launches;
            ILaunchManager launchmgr = DebugPlugin.getDefault().getLaunchManager();
            ILaunch[] iLaunchArray = launches = launchmgr.getLaunches();
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch.getAttribute(this.getPreferenceKey()) != null && !launch.isTerminated()) {
                    this.setEnabled(true);
                    return;
                }
                ++n2;
            }
        } else if (view instanceof BreakpointsView) {
            IBreakpoint[] bkpts;
            IBreakpointManager bkptmgr = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] iBreakpointArray = bkpts = bkptmgr.getBreakpoints();
            int n = bkpts.length;
            int n3 = 0;
            while (n3 < n) {
                IBreakpoint bkpt = iBreakpointArray[n3];
                try {
                    Object attr = bkpt.getMarker().getAttribute("org.eclipse.cdt.debug.ui.cDebug.capable_of_show_full_paths");
                    if (attr != null) {
                        this.setEnabled(true);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n3;
            }
        }
        super.selectionChanged(action, selection);
    }
}

