/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.export.excel.command;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.export.excel.ExcelExporter;
import net.sourceforge.nattable.export.excel.command.ExportToExcelCommand;
import net.sourceforge.nattable.grid.layer.GridLayer;
import net.sourceforge.nattable.print.command.PrintEntireGridCommand;
import net.sourceforge.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.FileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToExcelCommandHandler
extends AbstractLayerCommandHandler<ExportToExcelCommand> {
    private final GridLayer gridLayer;

    public ExportToExcelCommandHandler(GridLayer gridLayer) {
        this.gridLayer = gridLayer;
    }

    @Override
    public boolean doCommand(ExportToExcelCommand command) {
        OutputStream outputStream;
        block3: {
            try {
                outputStream = this.getOutputStream(command);
                if (outputStream != null) break block3;
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to export table to excel.", e);
            }
        }
        ExcelExporter excelExporter = new ExcelExporter(this.gridLayer, command.getConfigRegistry());
        this.setClientAreaToMaximum();
        excelExporter.export(command.getShell(), outputStream, this.getMaximumLayerSize());
        return true;
    }

    protected OutputStream getOutputStream(ExportToExcelCommand command) throws IOException {
        FileDialog dialog = new FileDialog(command.getShell(), 8192);
        dialog.setFilterPath("/");
        dialog.setOverwrite(true);
        dialog.setFileName("table_export.xls");
        dialog.setFilterExtensions(new String[]{"Microsoft Office Excel Workbook(.xls)"});
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        return new PrintStream(fileName);
    }

    private Rectangle getMaximumLayerSize() {
        int width = this.gridLayer.getWidth();
        int height = this.gridLayer.getHeight();
        int lastRowPosition = this.gridLayer.getColumnPositionByX(width - 1);
        int lastColPosition = this.gridLayer.getRowPositionByY(height - 1);
        return new Rectangle(0, 0, lastRowPosition, lastColPosition);
    }

    private void setClientAreaToMaximum() {
        final Rectangle maxClientArea = new Rectangle(0, 0, this.gridLayer.getWidth(), this.gridLayer.getHeight());
        this.gridLayer.setClientAreaProvider(new IClientAreaProvider(){

            public Rectangle getClientArea() {
                return maxClientArea;
            }
        });
        this.gridLayer.doCommand(new PrintEntireGridCommand());
    }

    @Override
    public Class<ExportToExcelCommand> getCommandClass() {
        return ExportToExcelCommand.class;
    }
}

