/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit;

import net.sourceforge.nattable.edit.ICellEditHandler;
import net.sourceforge.nattable.edit.command.UpdateDataCommand;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.command.MoveSelectionCommand;

public class SingleEditHandler
implements ICellEditHandler {
    private final ICellEditor cellEditor;
    private final ILayer layer;
    private final int columnPosition;
    private final int rowPosition;

    public SingleEditHandler(ICellEditor cellEditor, ILayer layer, int columnPosition, int rowPosition) {
        this.cellEditor = cellEditor;
        this.layer = layer;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
    }

    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeEditorAfterCommit) {
        Object canonicalValue = this.cellEditor.getCanonicalValue();
        switch (direction) {
            case LEFT: {
                this.layer.doCommand(new MoveSelectionCommand(SelectionLayer.MoveDirectionEnum.LEFT, 1, false, false));
                break;
            }
            case RIGHT: {
                this.layer.doCommand(new MoveSelectionCommand(SelectionLayer.MoveDirectionEnum.RIGHT, 1, false, false));
            }
        }
        boolean committed = this.layer.doCommand(new UpdateDataCommand(this.layer, this.columnPosition, this.rowPosition, canonicalValue));
        if (committed && closeEditorAfterCommit) {
            this.cellEditor.close();
            return true;
        }
        return committed;
    }
}

