/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.FunctionArguments;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupport;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;

public class Distance
implements Function {
    @Override
    public String getURI() {
        return GEOF.DISTANCE.stringValue();
    }

    @Override
    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 3) {
            throw new ValueExprEvaluationException(this.getURI() + " requires exactly 3 arguments, got " + args.length);
        }
        SpatialContext geoContext = SpatialSupport.getSpatialContext();
        Point p1 = FunctionArguments.getPoint(this, args[0], geoContext);
        Point p2 = FunctionArguments.getPoint(this, args[1], geoContext);
        IRI units = FunctionArguments.getUnits(this, args[2]);
        double distDegs = geoContext.calcDistance(p1, p2);
        double distUom = FunctionArguments.convertFromDegrees(distDegs, units);
        return valueFactory.createLiteral(distUom);
    }
}

