/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.model;

import java.io.ObjectStreamException;
import org.eclipse.rdf4j.model.impl.SimpleIRI;
import org.eclipse.rdf4j.sail.lmdb.ValueStoreRevision;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LmdbIRI
extends SimpleIRI
implements LmdbResource {
    private static final long serialVersionUID = -5888138591826143179L;
    private static final Logger log = LoggerFactory.getLogger(LmdbIRI.class);
    private volatile ValueStoreRevision revision;
    private volatile long internalID;
    private volatile boolean initialized = false;

    public LmdbIRI(ValueStoreRevision revision, long internalID) {
        this.setInternalID(internalID, revision);
    }

    public LmdbIRI(ValueStoreRevision revision, String uri) {
        this(revision, uri, -1L);
    }

    public LmdbIRI(ValueStoreRevision revision, String uri, long internalID) {
        super(uri);
        this.setInternalID(internalID, revision);
        this.initialized = true;
    }

    public LmdbIRI(ValueStoreRevision revision, String namespace, String localname) {
        this(revision, namespace + localname);
    }

    public LmdbIRI(ValueStoreRevision revision, String namespace, String localname, long internalID) {
        this(revision, namespace + localname, internalID);
    }

    @Override
    public void setInternalID(long internalID, ValueStoreRevision revision) {
        this.internalID = internalID;
        this.revision = revision;
    }

    @Override
    public ValueStoreRevision getValueStoreRevision() {
        return this.revision;
    }

    @Override
    public long getInternalID() {
        return this.internalID;
    }

    @Override
    public void setIRIString(String iriString) {
        super.setIRIString(iriString);
    }

    @Override
    public String getNamespace() {
        this.init();
        return super.getNamespace();
    }

    @Override
    public String getLocalName() {
        this.init();
        return super.getLocalName();
    }

    @Override
    public String stringValue() {
        this.init();
        return super.stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (!this.initialized) {
            LmdbIRI lmdbIRI = this;
            synchronized (lmdbIRI) {
                if (!this.initialized) {
                    boolean resolved = this.revision.resolveValue(this.internalID, this);
                    if (!resolved) {
                        log.warn("Could not resolve value");
                    }
                    this.initialized = resolved;
                }
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LmdbIRI && this.internalID != -1L) {
            LmdbIRI otherLmdbURI = (LmdbIRI)o;
            if (otherLmdbURI.internalID != -1L && this.revision.equals(otherLmdbURI.revision)) {
                return this.internalID == otherLmdbURI.internalID;
            }
        }
        return super.equals(o);
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.init();
        return this;
    }
}

