/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternFilter
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(PatternFilter.class);
    private final Pattern pattern;

    public PatternFilter(PlanNode parent, String pattern, String flags) {
        super(parent);
        if (flags != null && !flags.isEmpty()) {
            int flag = 0;
            if (flags.contains("i")) {
                flag |= 2;
                logger.trace("PatternFilter constructed with case insensitive flag");
            }
            if (flags.contains("d")) {
                flag |= 1;
                logger.trace("PatternFilter constructed with UNIX lines flag");
            }
            if (flags.contains("m")) {
                flag |= 8;
                logger.trace("PatternFilter constructed with multiline flag");
            }
            if (flags.contains("s")) {
                flag |= 0x20;
                logger.trace("PatternFilter constructed with dotall flag");
            }
            if (flags.contains("u")) {
                flag |= 0x40;
                logger.trace("PatternFilter constructed with unicode case flag");
            }
            if (flags.contains("x")) {
                flag |= 4;
                logger.trace("PatternFilter constructed with comments flag");
            }
            if (flags.contains("U")) {
                flag |= 0x100;
                logger.trace("PatternFilter constructed with unicode character class flag");
            }
            this.pattern = Pattern.compile(pattern, flag);
            logger.trace("PatternFilter constructed with pattern: {} and flags: {}", (Object)pattern, (Object)flags);
        } else {
            this.pattern = Pattern.compile(pattern);
            logger.trace("PatternFilter constructed with pattern: {} and no flags", (Object)pattern);
        }
    }

    @Override
    boolean checkTuple(FilterPlanNode.Reference t) {
        Value literal = t.get().getValue();
        return this.pattern.matcher(literal.stringValue()).matches();
    }

    @Override
    public String toString() {
        return "PatternFilter{pattern=" + this.pattern + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatternFilter that = (PatternFilter)o;
        return this.pattern.equals(that.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern);
    }
}

