/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.QueryManager;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class QueryResultIteration
extends AbstractCloseableIteration<BindingSet> {
    protected final CloseableIteration<BindingSet> inner;
    protected final QueryInfo queryInfo;
    protected final QueryManager qm;

    public QueryResultIteration(CloseableIteration<BindingSet> inner, QueryInfo queryInfo) {
        this.inner = inner;
        this.queryInfo = queryInfo;
        this.qm = queryInfo.getFederationContext().getQueryManager();
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        if (this.inner.hasNext()) {
            return true;
        }
        this.qm.finishQuery(this.queryInfo);
        return false;
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        try {
            BindingSet next = (BindingSet)this.inner.next();
            if (next == null) {
                this.qm.finishQuery(this.queryInfo);
            }
            return next;
        }
        catch (QueryEvaluationException e) {
            this.abortQuery();
            throw e;
        }
    }

    @Override
    public void remove() throws QueryEvaluationException {
        this.inner.remove();
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            this.inner.close();
        }
        finally {
            try {
                this.abortQuery();
            }
            finally {
                this.queryInfo.close();
            }
        }
    }

    protected void abortQuery() {
        if (this.qm.isRunning(this.queryInfo)) {
            this.qm.abortQuery(this.queryInfo);
        }
    }
}

